/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.server.FileSystemInformationListener;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.FileSystemInfo;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FileSystemWatcher {
    static ESLLogger logger = ESLLogger.getLogger(FileSystemWatcher.class);
    public static final String SYSTEM_PARTITION = "System Partition";
    public static final String DATA_PARTITION = "Data Partition";
    public static final String CONFIG_PARTITION = "Config Partition";
    private final Set<FileSystemInformationListener> listeners;
    private final Map<File, String> filesToWatch;

    public FileSystemWatcher() {
        this(null);
    }

    public FileSystemWatcher(Map<File, String> filesToWatch) {
        this.filesToWatch = filesToWatch;
        this.listeners = new LinkedHashSet<FileSystemInformationListener>();
    }

    public void registerListener(FileSystemInformationListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(FileSystemInformationListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(FileSystemInfo fileSystemInfo) {
        for (FileSystemInformationListener listener : this.listeners) {
            listener.notifyFileSystemInformationUpdated(fileSystemInfo);
        }
    }

    public synchronized void updateFileSystemInformation() {
        if (this.filesToWatch != null && this.filesToWatch.size() > 0) {
            FileSystemInfo info = new FileSystemInfo();
            for (Map.Entry<File, String> entry : this.filesToWatch.entrySet()) {
                info.addFileSystem(entry.getKey(), entry.getValue());
            }
            this.notifyListeners(info);
        }
    }

    public File getFileByKey(String partitionKey) {
        if (this.filesToWatch == null) {
            return null;
        }
        for (Map.Entry<File, String> entry : this.filesToWatch.entrySet()) {
            if (!partitionKey.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

