/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.accesspoint.AccessPointControllerManager;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.AbstractESLProcessing;
import at.mrdevelopment.esl.core.ESLProcessing;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.core.OneTimeTaskExecutor;
import at.mrdevelopment.esl.core.UpdateResultFactory;
import at.mrdevelopment.esl.core.UpdateStatusListener;
import at.mrdevelopment.esl.core.WakeupNotifier;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.server.AccessPointCommunication;
import at.mrdevelopment.esl.server.AutoConfigurationBroadcastProcessor;
import at.mrdevelopment.esl.server.ConfigEnvironmentSource;
import at.mrdevelopment.esl.server.DiscoveredAccessPointsHolder;
import at.mrdevelopment.esl.server.LabelPageContentStorage;
import at.mrdevelopment.esl.server.PersistLabelInfoCache;
import at.mrdevelopment.esl.server.ProvisioningOneTimeTaskExecutor;
import at.mrdevelopment.esl.server.ScheduledAbortRequestProcessing;
import at.mrdevelopment.esl.server.ScheduledTaskProcessing;
import at.mrdevelopment.esl.server.ServiceScheduler;
import at.mrdevelopment.esl.server.UpdateStatusUpdater;
import at.mrdevelopment.esl.server.WaitingTaskCache;
import at.mrdevelopment.esl.server.WaitingTaskProcessing;
import at.mrdevelopment.esl.server.provisioning.APDiscoveryProcessing;
import at.mrdevelopment.esl.server.provisioning.ProvisioningModule;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagModulesProvider;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointProvisioningQueries;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.AccessPointSoftwareUpdateProcessing;
import at.mrdevelopment.esl.server.provisioning.usb.USBAccessPointModulesProvider;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.AbortTaskRequest;
import at.mrdevelopment.esl.tasks.AbortTransactionRequest;
import at.mrdevelopment.esl.tasks.ConfigBasedRenderedImageConverter;
import at.mrdevelopment.esl.tasks.EnvironmentSource;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.FileRecordSourceLogger;
import at.mrdevelopment.esl.tasks.ForceUpdateTask;
import at.mrdevelopment.esl.tasks.InternalTask;
import at.mrdevelopment.esl.tasks.NothingTask;
import at.mrdevelopment.esl.tasks.RecordSourceLogger;
import at.mrdevelopment.esl.tasks.RenderedImageConverter;
import at.mrdevelopment.esl.tasks.ResendTask;
import at.mrdevelopment.esl.tasks.RetryTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.tasks.UpdateStatusFactory;
import at.mrdevelopment.esl.template.ImageRenderingEngineWrapper;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTaskFactory;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.UUID;

public class ESLProcessingImpl
extends AbstractESLProcessing
implements UpdateStatusListener {
    static ESLLogger logger = ESLLogger.getLogger(ESLProcessingImpl.class);
    private final Level1Implementation level1;
    private final UpdateStatusFactory updateStatusFactory;
    private final UpdateTaskFactory updateTaskFactory;
    private final UpdateResultFactory updateResultFactory;
    private final UpdateStatusUpdater updateStatusUpdater;
    private final AccessPointCommunication accessPointCommunication;
    private final ScheduledTaskProcessing scheduledTaskProcessing;
    private final ScheduledAbortRequestProcessing scheduledAbortRequestProcessing;
    private final LabelInfoDataset labelInfoDataset;
    private final UpdateStatusDataset updateStatusDataset;
    private final WaitingTaskCache waitingTaskCache;
    private final WaitingTaskProcessing waitingTaskProcessing;
    private final APDiscoveryProcessing discoveryProcessing;
    private final LabelPageContentStorage labelPageContentStorage;
    private final TransactionSupplier transactionSupplier;

    public ESLProcessingImpl(Level1Implementation level1, Version version, UpdateStatusUpdater updateStatusUpdater, LabelInfoDataset labelInfoDataset, UpdateStatusDataset updateStatusDataset, LabelInfoHistoryDataset labelInfoHistoryDataset, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset, AccessPointConfigurationDataset accessPointConfigurationDataset, AccessPointInfoDataset accessPointInfoDataset, WaitingTaskCache waitingTaskCache, AccessPointControllerManager accessPointControllerManager, FeatureUnlock featureUnlock, AccessPointProvisioningQueries apProvisioningQueries, ImageRenderingEngineWrapper imageRenderingEngineWrapper, PersistLabelInfoCache persistLabelInfoCache, ServiceScheduler serviceManager, AccessPointSoftwareUpdateProcessing accessPointSoftwareUpdateProcessing, ServerStartupSettings serverStartupSettings) throws InitializationException, DatasetException {
        this.level1 = level1;
        this.updateStatusFactory = new UpdateStatusFactory();
        this.updateTaskFactory = new UpdateTaskFactory(new UpdateImageFactory(imageRenderingEngineWrapper, (RenderedImageConverter)new ConfigBasedRenderedImageConverter(), (RecordSourceLogger)new FileRecordSourceLogger(), (EnvironmentSource)new ConfigEnvironmentSource(), (LabelTagsLookup)labelInfoDataset), Config.isUnlockAllPages(), Config.isResetToRegistrationPage());
        this.updateResultFactory = new UpdateResultFactory();
        this.updateStatusUpdater = updateStatusUpdater;
        this.labelInfoDataset = labelInfoDataset;
        this.waitingTaskCache = waitingTaskCache;
        this.updateStatusDataset = updateStatusDataset;
        this.transactionSupplier = level1.getTransactionSupplier();
        DiscoveredAccessPointsHolder discoveredImagoAPsHolder = new DiscoveredAccessPointsHolder();
        AutoConfigurationBroadcastProcessor broadcastProcessor = new AutoConfigurationBroadcastProcessor(version, accessPointConfigurationDataset, accessPointInfoDataset, discoveredImagoAPsHolder);
        ImagotagModulesProvider imagoModulesProvider = new ImagotagModulesProvider(accessPointInfoDataset, broadcastProcessor, discoveredImagoAPsHolder, serverStartupSettings);
        USBAccessPointModulesProvider usbAccessPointModulesProvider = new USBAccessPointModulesProvider(discoveredImagoAPsHolder);
        ProvisioningModule provisioningModule = new ProvisioningModule(level1.getTransactionSupplier(), accessPointConfigurationDataset, accessPointInfoDataset, apProvisioningQueries, accessPointSoftwareUpdateProcessing);
        provisioningModule.addModules(imagoModulesProvider);
        provisioningModule.addModules(usbAccessPointModulesProvider);
        ProvisioningOneTimeTaskExecutor oneTimeTaskExecutor = new ProvisioningOneTimeTaskExecutor(level1.getTransactionSupplier(), provisioningModule);
        Transaction transaction = level1.getTransactionSupplier().newTransaction();
        try {
            accessPointConfigurationDataset.registerAccessPointListener(oneTimeTaskExecutor, transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new InitializationException((Throwable)exc);
        }
        this.accessPointCommunication = new AccessPointCommunication(level1.getTransactionSupplier(), accessPointConfigurationDataset, accessPointInfoDataset, labelInfoDataset, (WakeupNotifier)this, level1, featureUnlock, labelInfoHistoryDataset);
        this.scheduledTaskProcessing = new ScheduledTaskProcessing((ESLProcessing)this, waitingTaskCache, this.transactionSupplier);
        this.scheduledAbortRequestProcessing = new ScheduledAbortRequestProcessing((ESLProcessing)this, this.transactionSupplier);
        this.waitingTaskProcessing = new WaitingTaskProcessing(this.updateStatusFactory, this.updateTaskFactory, updateStatusUpdater, this.accessPointCommunication, waitingTaskCache, featureUnlock, labelInfoDataset, this.transactionSupplier, labelPageContentDataset, labelActivePageDataset, this.scheduledAbortRequestProcessing);
        this.discoveryProcessing = new APDiscoveryProcessing(provisioningModule, discoveredImagoAPsHolder, (OneTimeTaskExecutor)oneTimeTaskExecutor);
        this.labelPageContentStorage = new LabelPageContentStorage(labelInfoDataset, labelPageContentDataset, labelActivePageDataset);
        this.registerShutdownable(accessPointControllerManager);
        this.registerShutdownable((Shutdownable)this.accessPointCommunication);
        this.registerShutdownable((Shutdownable)this.scheduledTaskProcessing);
        this.registerShutdownable((Shutdownable)this.waitingTaskProcessing);
        this.registerShutdownable((Shutdownable)this.discoveryProcessing);
        this.registerShutdownable((Shutdownable)broadcastProcessor);
    }

    public void start() {
        this.accessPointCommunication.start();
        this.scheduledTaskProcessing.start();
        this.waitingTaskProcessing.start();
        this.discoveryProcessing.start();
    }

    private void updateFinished(Update update, Transaction<?> transaction) throws DatasetException {
        this.removeUpdateTasksFromAccessPoints(update);
        this.labelPageContentStorage.updateFinished(update, transaction);
        if (update.isUnsuccessful() && update.isValidRetry()) {
            this.createRetryTask(update, transaction);
        } else {
            UpdateResult updateResult = this.updateResultFactory.createFromUpdate(update);
            this.notifyUpdateFinished(updateResult);
        }
    }

    private void removeUpdateTasksFromAccessPoints(Update update) {
        UUID taskId = update.getTaskId();
        int accessPointId = update.getAccessPointId();
        if (update.isAssigned()) {
            if (update.isAborted() || update.getUpdateError() == UpdateError.ERROR_CODE_UPDATE_LOST) {
                this.abortTaskOnAccessPoint(accessPointId, taskId);
            }
            if (update.isFinished()) {
                this.removeTaskFromAccessPoint(accessPointId, taskId);
            }
        }
    }

    private void abortTaskOnAccessPoint(int accessPointId, UUID taskId) {
        logger.info("Sending abort request for update task %s to access point %d", new Object[]{taskId, accessPointId});
        this.accessPointCommunication.scheduleTaskForAborting(accessPointId, taskId);
    }

    private void removeTaskFromAccessPoint(int accessPointId, UUID taskId) {
        logger.info("Sending remove request for update task %s to access point %d", new Object[]{taskId, accessPointId});
        this.accessPointCommunication.scheduleTaskForRemoval(accessPointId, taskId);
    }

    public void scheduleTask(TaskTransaction transaction, Task task) {
        this.scheduledTaskProcessing.scheduleTask(transaction, task);
    }

    public void scheduleAbortRequest(AbortRequest abortRequest) {
        this.scheduledAbortRequestProcessing.scheduleAbortRequest(abortRequest);
    }

    public void processTask(TaskTransaction taskTransaction, Task task, Transaction<?> transaction) throws DatasetException, SerializeException {
        if (task instanceof ErrorTask) {
            ErrorTask errorTask = (ErrorTask)task;
            this.processErrorTask(taskTransaction, errorTask, transaction);
        } else if (task instanceof InternalTask) {
            InternalTask internalTask = (InternalTask)task;
            this.convertInternalTask(taskTransaction, internalTask, transaction);
        } else if (task instanceof ExecutableTask) {
            ExecutableTask executableTask = (ExecutableTask)task;
            if (executableTask.isLocked() && !Config.isUnlockAllTasks() && !taskTransaction.isInternal()) {
                ErrorTask errorTask = new ErrorTask(executableTask, UpdateError.ERROR_CODE_TASK_NOT_ALLOWED);
                this.processErrorTask(taskTransaction, errorTask, transaction);
            } else if (executableTask.getTaskType().isImage() && !executableTask.getLabelId().getLabelType().isValidForSendingImages()) {
                ErrorTask errorTask = new ErrorTask(executableTask, UpdateError.ERROR_CODE_UNSUPPORTED_LABEL_TYPE);
                this.processErrorTask(taskTransaction, errorTask, transaction);
            } else {
                this.processExecutableTask(taskTransaction, executableTask, transaction);
            }
        } else {
            ErrorTask errorTask = new ErrorTask(task, UpdateError.ERROR_CODE_UNSUPPORTED_TASK);
            this.processErrorTask(taskTransaction, errorTask, transaction);
        }
    }

    public void processErrorTask(TaskTransaction taskTransaction, ErrorTask task, Transaction<?> transaction) throws DatasetException, SerializeException {
        Update update = this.updateStatusFactory.createError(taskTransaction, task);
        this.processNewUpdate(update, transaction);
    }

    public void processAbortRequest(AbortRequest abortRequest, Transaction<?> transaction) {
        if (abortRequest instanceof AbortTaskRequest) {
            this.abortTask((AbortTaskRequest)abortRequest, transaction);
        } else if (abortRequest instanceof AbortTransactionRequest) {
            this.abortTransaction((AbortTransactionRequest)abortRequest, transaction);
        } else {
            logger.warn("Processing unsupported abort request of type %s", new Object[]{abortRequest.getClass().getSimpleName()});
        }
    }

    private void convertInternalTask(TaskTransaction taskTransaction, InternalTask task, Transaction<?> transaction) throws DatasetException, SerializeException {
        if (task instanceof NothingTask) {
            return;
        }
        if (task instanceof RetryTask) {
            RetryTask retryTask = (RetryTask)task;
            this.processRetryTask(taskTransaction, retryTask, transaction);
        } else if (task instanceof ResendTask) {
            ResendTask resendTask = (ResendTask)task;
            this.processResendTask(taskTransaction, resendTask, transaction);
        } else if (task instanceof ForceUpdateTask) {
            ForceUpdateTask forceUpdateTask = (ForceUpdateTask)task;
            this.processForceUpdateTask(taskTransaction, forceUpdateTask, transaction);
        } else {
            Task internalTask = this.updateTaskFactory.convertInternalTask(task);
            this.processTask(taskTransaction, internalTask, transaction);
        }
    }

    private void processExecutableTask(TaskTransaction taskTransaction, ExecutableTask task, Transaction<?> transaction) throws DatasetException, SerializeException {
        Update update = this.updateStatusFactory.createUpdate(taskTransaction, task);
        this.processNewUpdate(update, transaction);
    }

    private void processRetryTask(TaskTransaction taskTransaction, RetryTask task, Transaction<?> transaction) throws DatasetException, SerializeException {
        Update referencedUpdate = this.updateStatusDataset.queryByTaskId(task.getTaskId(), transaction);
        Update update = referencedUpdate == null ? Update.createError((TransactionRecord)((TransactionRecord)taskTransaction), (ErrorTask)new ErrorTask((Task)task, UpdateError.ERROR_CODE_RESOURCE_NOT_AVAILABLE), (UUID)task.getTaskId(), (UpdateError)UpdateError.ERROR_CODE_RESOURCE_NOT_AVAILABLE) : this.updateStatusFactory.createRetry(referencedUpdate);
        this.updateStatusUpdater.addUpdateStatus(update, transaction);
    }

    private void processResendTask(TaskTransaction taskTransaction, ResendTask task, Transaction<?> transaction) throws DatasetException, SerializeException {
        Update referencedUpdate = this.updateStatusDataset.queryByTaskId(task.getTaskId(), transaction);
        Update update = referencedUpdate != null ? this.updateStatusFactory.createResend(taskTransaction, referencedUpdate) : this.updateStatusFactory.createError(taskTransaction, new ErrorTask((Task)task, UpdateError.ERROR_CODE_RESOURCE_NOT_AVAILABLE));
        this.processNewUpdate(update, transaction);
    }

    private void processForceUpdateTask(TaskTransaction taskTransaction, ForceUpdateTask task, Transaction<?> transaction) throws DatasetException {
        LabelId labelId = task.getLabelId();
        TaskPriority priority = task.getPriority();
        long externalId = task.getExternalId();
        this.level1.forceUpdate(taskTransaction, labelId, priority, externalId);
    }

    private void processNewUpdate(Update update, Transaction<?> transaction) throws DatasetException {
        if (!update.isUnsuccessful()) {
            logger.info("Handling update: %s", new Object[]{update.getTaskId()});
            LabelId labelId = update.getLabelId();
            if (!this.labelInfoDataset.isLicenced(labelId) && update.isLicenceRequired()) {
                update.setError(UpdateError.ERROR_CODE_UNLICENCED);
            }
        }
        this.updateStatusUpdater.addUpdateStatus(update, transaction);
    }

    private void createRetryTask(Update update, Transaction<?> transaction) throws DatasetException {
        try {
            RetryTask task = new RetryTask(update.getLabelId(), update.getPriority(), update.getExternalId(), update.getTaskId());
            this.processRetryTask((TaskTransaction)update.getTaskRecord().getTransaction(), task, transaction);
        }
        catch (Exception exc) {
            logger.warn("Failed to create retry of update task %s", new Object[]{update.getTaskId()});
            logger.logException((Throwable)exc);
            update.setError(UpdateError.ERROR_CODE_INTERNAL);
            this.waitingTaskCache.updateStatusChanged(update, transaction);
        }
    }

    private void abortTask(AbortTaskRequest abortRequest, Transaction<?> transaction) {
        logger.debug("Processing abort request for update task %s", new Object[]{abortRequest.getTaskId()});
        UUID taskId = abortRequest.getTaskId();
        Update update = this.waitingTaskCache.getWaitingOrDelayedTask(taskId);
        this.abortUpdate(update, transaction);
    }

    private void abortTransaction(AbortTransactionRequest abortRequest, Transaction<?> transaction) {
        logger.debug("Processing abort request for transaction %d", new Object[]{abortRequest.getTransactionId()});
        for (Update update : this.waitingTaskCache.getWaitingAndDelayedUpdatesForTransaction(abortRequest.getTransactionId())) {
            this.abortUpdate(update, transaction);
        }
    }

    private void abortUpdate(Update update, Transaction<?> transaction) {
        if (update != null && update.hasUpdateStatus() && !update.isFinished()) {
            UUID taskId = update.getTaskId();
            try {
                logger.info("Aborting update task %s", new Object[]{taskId});
                this.updateStatusUpdater.cancel(update, transaction);
            }
            catch (Exception exc) {
                logger.warn("Could not abort update %s: %s", new Object[]{taskId.toString(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    @Override
    public void updateStatusAdded(Update update, Transaction<?> transaction) throws DatasetException {
        if (update.isFinished()) {
            this.updateFinished(update, transaction);
        }
    }

    @Override
    public void updateStatusChanged(Update update, Transaction<?> transaction) throws DatasetException {
        if (update.isFinished()) {
            this.updateFinished(update, transaction);
        }
    }

    @Override
    public void updateStatusRemoved(Update update, Transaction<?> transaction) {
    }

    public boolean isFinished() {
        return false;
    }

    public void shutdown() {
        super.shutdown();
    }

    public int getScheduledTaskCount() {
        return this.scheduledTaskProcessing.getScheduledTaskCount();
    }
}

