/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceManager;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collection;

public abstract class ESLAccessPointProcessingTask
implements ESLProcessingTask {
    static ESLLogger logger = ESLLogger.getLogger(ESLAccessPointProcessingTask.class);
    private final String taskName;
    private final AccessPointServiceManager accessPointInfoDataset;

    public ESLAccessPointProcessingTask(String taskName, AccessPointServiceManager accessPointInfoDataset) {
        this.taskName = taskName;
        this.accessPointInfoDataset = accessPointInfoDataset;
    }

    public void run() throws Exception {
        Collection<AccessPointService> accessPointServices = this.accessPointInfoDataset.getAccessPoints();
        this.runBefore();
        for (AccessPointService accessPointService : accessPointServices) {
            try {
                this.runForAccessPoint(accessPointService);
            }
            catch (WebserviceException exc) {
                logger.error("%s: Could not connect to access point (%s)", new Object[]{this.taskName, exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (DatasetException exc) {
                logger.error("%s: Could not persist to database (%s)", new Object[]{this.taskName, exc.getMessage()});
                logger.logException((Throwable)exc);
            }
            catch (SerializeException exc) {
                logger.error("Could not create tasks for access point (%s)", new Object[]{this.taskName, exc.getMessage()});
                logger.logException((Throwable)exc);
            }
            catch (Exception exc) {
                logger.error("%s: Unknown exception during service task processing (%s)", new Object[]{this.taskName, exc.getMessage()});
                logger.logException((Throwable)exc);
            }
        }
        this.runAfterwards();
    }

    public abstract void runForAccessPoint(AccessPointService var1) throws Exception;

    public void runBefore() throws Exception {
    }

    public void runAfterwards() throws Exception {
    }
}

