/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DiscoveredAccessPointsHolder {
    private final Map<Integer, AccessPointInfo> discoveredAccessPoints;
    private final Object lock;
    private volatile boolean discoveryEnabled = Config.isListenForAccessPointBroadcastEnabled();

    public DiscoveredAccessPointsHolder() {
        this.lock = new Object();
        this.discoveredAccessPoints = new HashMap<Integer, AccessPointInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveredAccessPointInfo(AccessPointInfo accessPointInfo) {
        Object object = this.lock;
        synchronized (object) {
            int accessPointId = accessPointInfo.getAccessPointId();
            this.discoveredAccessPoints.put(accessPointId, accessPointInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutDiscoveredAccessPoints() {
        DateTime currentTime = DateTime.now();
        Object object = this.lock;
        synchronized (object) {
            Iterator<AccessPointInfo> iterator = this.discoveredAccessPoints.values().iterator();
            while (iterator.hasNext()) {
                AccessPointInfo accessPointInfo = iterator.next();
                DateTime validTime = accessPointInfo.getUpdateTime().plusMinutes(Config.getBroadcastIntervalInMinutes() + 10);
                if (!accessPointInfo.isDiscovered() || !currentTime.isAfter((ReadableInstant)validTime)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessPointInfo> getAccessPoints() {
        List<Object> list;
        if (this.discoveryEnabled) {
            Object object = this.lock;
            synchronized (object) {
                list = new ArrayList<AccessPointInfo>(this.discoveredAccessPoints.values());
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.discoveredAccessPoints.isEmpty()) {
                this.discoveredAccessPoints.clear();
            }
        }
        list = Collections.emptyList();
        return list;
    }

    public void setDiscoveryEnabled(boolean enabled) {
        this.discoveryEnabled = enabled;
    }
}

