/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.server.UpdateExecutionStrategy;
import at.mrdevelopment.esl.server.UpdateImageSkippingStrategy;
import at.mrdevelopment.esl.server.UpdateReplacementStrategy;
import at.mrdevelopment.esl.server.UpdateStatusUpdater;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.joda.time.DateTime;

public class DelayedTaskProcessing {
    static ESLLogger logger = ESLLogger.getLogger(DelayedTaskProcessing.class);
    private final UpdateStatusUpdater updateStatusUpdater;
    private final UpdateExecutionStrategy updateExecutionStrategy;
    private final UpdateReplacementStrategy updateReplacementStrategy;
    private final UpdateImageSkippingStrategy updateImageSkippingStrategy;

    public DelayedTaskProcessing(UpdateStatusUpdater updateStatusUpdater, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset) {
        this.updateStatusUpdater = updateStatusUpdater;
        this.updateExecutionStrategy = new UpdateExecutionStrategy();
        this.updateReplacementStrategy = new UpdateReplacementStrategy();
        this.updateImageSkippingStrategy = new UpdateImageSkippingStrategy(labelPageContentDataset, labelActivePageDataset);
    }

    public void processUpdates(Collection<Update> waitingOrDelayedUpdates, Transaction<?> transaction) throws DatasetException {
        this.startConcurrentDelayedUpdates(waitingOrDelayedUpdates, transaction);
        Collection sequentialUpdates = Collections2.filter(waitingOrDelayedUpdates, (Predicate)new Predicate<Update>(){

            public boolean apply(Update update) {
                return DelayedTaskProcessing.this.updateExecutionStrategy.getAction(update).isSequential();
            }
        });
        ArrayList<Update> predecessorUpdates = new ArrayList<Update>();
        for (Update currentUpdate : sequentialUpdates) {
            if (currentUpdate.isDelayed()) {
                logger.info("Testing delayed update %s (taskType=%s, page=%s)", new Object[]{currentUpdate.getTaskId(), currentUpdate.getTaskType(), currentUpdate.getPage()});
                boolean replaceWaitingTasks = currentUpdate.isReplaceWaitingTasks();
                Map<UpdateReplacementStrategy.ActionType, Collection<Update>> replacementActions = this.updateReplacementStrategy.getReplacementActions(predecessorUpdates, currentUpdate, replaceWaitingTasks);
                Collection<Update> previousUpdatesToBeReplaced = replacementActions.get((Object)UpdateReplacementStrategy.ActionType.REPLACE_OLD_UPDATE);
                Collection<Update> previousUpdatesDelayingCurrentUpdate = replacementActions.get((Object)UpdateReplacementStrategy.ActionType.DELAY_NEW_UPDATE);
                Collection<Update> previousUpdatesRemovingCurrentUpdate = replacementActions.get((Object)UpdateReplacementStrategy.ActionType.REMOVE_NEW_UPDATE);
                Collection<Update> previousUpdatesWithoutRelationsToCurrentUpdate = replacementActions.get((Object)UpdateReplacementStrategy.ActionType.NO_ACTION);
                for (Update updateToBeReplaced : previousUpdatesToBeReplaced) {
                    logger.info("Replacing previous update %s because of %s", new Object[]{updateToBeReplaced.getTaskId(), currentUpdate.getTaskId()});
                    this.updateStatusUpdater.replace(updateToBeReplaced, transaction);
                }
                logger.info("%d previous updates delaying update %s", new Object[]{previousUpdatesDelayingCurrentUpdate.size(), currentUpdate.getTaskId()});
                logger.info("%d previous updates removing update %s", new Object[]{previousUpdatesRemovingCurrentUpdate.size(), currentUpdate.getTaskId()});
                logger.info("%d previous updates without relation to update %s", new Object[]{previousUpdatesWithoutRelationsToCurrentUpdate.size(), currentUpdate.getTaskId()});
                if (previousUpdatesDelayingCurrentUpdate.isEmpty()) {
                    logger.info("Current update %s not delayed by other updates and is ready to be started", new Object[]{currentUpdate.getTaskId()});
                    int transmissionDelay = currentUpdate.getTransmissionDelayInSeconds();
                    DateTime earliestStartTime = currentUpdate.getUpdateStatus().getCreatedAt().plusSeconds(transmissionDelay);
                    if (earliestStartTime.isBeforeNow()) {
                        this.startUpdate(currentUpdate, transaction);
                    } else {
                        logger.info("Task cannot be started yet because of transmission delay until %s", new Object[]{earliestStartTime});
                    }
                }
            }
            predecessorUpdates.add(currentUpdate);
        }
    }

    private void startConcurrentDelayedUpdates(Collection<Update> delayedUpdates, Transaction<?> transaction) throws DatasetException {
        Collection concurrentDelayedUpdates = Collections2.filter(delayedUpdates, (Predicate)new Predicate<Update>(){

            public boolean apply(Update update) {
                return update.isDelayed() && DelayedTaskProcessing.this.updateExecutionStrategy.getAction(update).isConcurrent();
            }
        });
        for (Update update : concurrentDelayedUpdates) {
            logger.info("Concurrent update %s, set status to WAITING", new Object[]{update.getTaskId()});
            this.updateStatusUpdater.start(update, transaction);
        }
    }

    private void startUpdate(Update update, Transaction<?> transaction) throws DatasetException {
        boolean skipOnEqualImage;
        boolean bl = skipOnEqualImage = Config.isForceSkipOnEqualImage() || update.isSkipOnEqualImage();
        if (skipOnEqualImage) {
            UpdateImageSkippingStrategy.SkipAction skipAction = this.updateImageSkippingStrategy.getSkipAction(update, transaction);
            if (skipAction == UpdateImageSkippingStrategy.SkipAction.SKIP) {
                logger.info("Skipping update %s (image equals last successful transmitted image)", new Object[]{update.getTaskId()});
                this.updateStatusUpdater.skip(update, transaction);
            } else if (skipAction == UpdateImageSkippingStrategy.SkipAction.REPLACE_WITH_SWITCH_PAGE) {
                logger.info("Change task type of update %s to SWITCH_PAGE (image equals last successful preloaded image)", new Object[]{update.getTaskId()});
                TaskRecord taskRecord = update.getTaskRecord();
                taskRecord.setTaskType(TaskType.SWITCH_PAGE);
                taskRecord.setUpdateImage(null);
                this.updateStatusUpdater.start(update, transaction);
            } else if (skipAction == UpdateImageSkippingStrategy.SkipAction.SEND) {
                this.updateStatusUpdater.start(update, transaction);
            }
        } else {
            this.updateStatusUpdater.start(update, transaction);
        }
    }
}

