/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.custom.ConnectorConfiguration;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class DatasetInstanceFactory {
    static ESLLogger logger = ESLLogger.getLogger(DatasetInstanceFactory.class);
    private final Collection<? extends Dataset<?>> datasets;

    public DatasetInstanceFactory(ClassLoader classLoader, ConnectorConfiguration connectorConfiguration) throws InitializationException {
        this.datasets = this.loadDatasets(classLoader, connectorConfiguration.loadDatasetClasses(classLoader));
    }

    private Collection<? extends Dataset<?>> loadDatasets(ClassLoader classLoader, Collection<Class<?>> datasetClasses) throws InitializationException {
        ArrayList datasets = new ArrayList();
        for (Class<?> datasetClass : datasetClasses) {
            try {
                logger.debug("Loading dataset for class %s", new Object[]{datasetClass.getName()});
                Constructor<?> constructor = datasetClass.getConstructor(new Class[0]);
                datasets.add(Dataset.class.cast(constructor.newInstance(new Object[0])));
            }
            catch (ClassCastException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (InstantiationException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (IllegalAccessException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (IllegalArgumentException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (InvocationTargetException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (SecurityException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (NoSuchMethodException exc) {
                throw new InitializationException((Throwable)exc);
            }
        }
        return datasets;
    }

    public Collection<Dataset<?>> getDatasets() {
        return Collections.unmodifiableCollection(this.datasets);
    }
}

