/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.problem.PersistentProblemStatus;
import at.mrdevelopment.esl.core.problem.ProblemStatus;
import at.mrdevelopment.esl.custom.ESLConnector;
import at.mrdevelopment.esl.custom.ESLInterface;
import at.mrdevelopment.esl.server.data.DataMigration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.problem.MessageProblem;
import at.mrdevelopment.toolkit.problem.Problem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConnectorInstanceFactory<C extends ESLConnector, I extends ESLInterface>
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(ConnectorInstanceFactory.class);
    private final Map<Class<? extends C>, C> connectorInstances = new HashMap<Class<? extends C>, C>();

    public ConnectorInstanceFactory(ClassLoader classLoader, Collection<String> connectorClassNames, Class<C> connectorType) {
        this.loadConnectorClasses(classLoader, connectorClassNames, connectorType);
    }

    public Collection<C> getConnectors() {
        return Collections.unmodifiableCollection(this.connectorInstances.values());
    }

    public void shutdown() {
        for (ESLConnector connectorInstance : this.connectorInstances.values()) {
            connectorInstance.shutdown();
        }
        this.connectorInstances.clear();
    }

    public void loadConnectors(ClassLoader classLoader, Collection<String> connectorClassNames, Class<C> connectorType, Class<I> interfaceType, I interfaceInstance) {
        for (String connectorClassName : connectorClassNames) {
            try {
                Class<C> connectorClass = this.loadClass(classLoader, connectorClassName, connectorType);
                C connectorInstance = this.getCustomInterfaceInstance(connectorClass, interfaceType, interfaceInstance);
                this.connectorInstances.put(connectorType, connectorInstance);
            }
            catch (InitializationException exc) {
                if (exc.getCause() != null && exc.getCause() instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)exc.getCause()).getTargetException();
                    logger.warn("Could not load connector %s: %s", new Object[]{connectorClassName, targetException.getMessage()});
                    logger.logExceptionIfDebugEnabled(targetException);
                } else {
                    logger.warn("Could not load connector %s: %s", new Object[]{connectorClassName, exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
                try {
                    String simpleName = StringUtils.substringAfterLast((String)connectorClassName, (String)".");
                    interfaceInstance.registerProblemStatus((ProblemStatus)new PersistentProblemStatus((Problem)MessageProblem.createError((String)String.format("plugin-loading-error-%s", simpleName), (String)String.format("Could not load plugin %s", simpleName))));
                }
                catch (InitializationException exc1) {
                    logger.warn("Could not register problem status: %s", new Object[]{exc1.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc1);
                }
            }
        }
    }

    private void loadConnectorClasses(ClassLoader classLoader, Collection<String> connectorClassNames, Class<C> connectorType) {
        for (String connectorClassName : connectorClassNames) {
            try {
                this.loadClass(classLoader, connectorClassName, connectorType);
            }
            catch (InitializationException exc) {
                if (exc.getCause() != null && exc.getCause() instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)exc.getCause()).getTargetException();
                    logger.warn("Could not load connector %s: %s", new Object[]{connectorClassName, targetException.getMessage()});
                    logger.logExceptionIfDebugEnabled(targetException);
                    continue;
                }
                logger.warn("Could not load connector %s: %s", new Object[]{connectorClassName, exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    public <T> T loadDataMigrationInstance(ClassLoader classLoader, PlatformStorage platformStorage, Class<I> interfaceType, I interfaceInstance, String dataMigrationClassName) throws InitializationException {
        try {
            Class<?> dataMigrationClass = this.loadClass(classLoader, dataMigrationClassName);
            return this.createDataMigrationInstance(dataMigrationClass, interfaceType, interfaceInstance, classLoader, platformStorage);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private C getCustomInterfaceInstance(Class<? extends C> connectorClass, Class<I> interfaceType, I interfaceInstance) throws InitializationException {
        if (this.connectorInstances.containsKey(connectorClass)) {
            return (C)((ESLConnector)connectorClass.cast(this.connectorInstances.get(connectorClass)));
        }
        C connectorInstance = this.createInstance(connectorClass, interfaceType, interfaceInstance);
        this.connectorInstances.put(connectorClass, connectorInstance);
        return connectorInstance;
    }

    private Class<? extends C> loadClass(ClassLoader classLoader, String className, Class<C> targetType) throws InitializationException {
        try {
            Class<?> type = this.loadClass(classLoader, className);
            return (Class)targetType.getClass().cast(type);
        }
        catch (ExceptionInInitializerError exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (LinkageError exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (ClassCastException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) throws InitializationException {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private C createInstance(Class<? extends C> connectorClass, Class<I> interfaceType, I interfaceInstance) throws InitializationException {
        try {
            Constructor<C> constructor = connectorClass.getConstructor(interfaceType);
            return (C)((ESLConnector)constructor.newInstance(interfaceInstance));
        }
        catch (InstantiationException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (ExceptionInInitializerError exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private <T, D extends DataMigration> T createDataMigrationInstance(Class<?> connectorClass, Class<I> interfaceType, I interfaceInstance, ClassLoader classLoader, PlatformStorage platformStorage) throws InitializationException {
        try {
            Constructor<?> constructor = connectorClass.getConstructor(interfaceType);
            DataMigration instance = (DataMigration)constructor.newInstance(interfaceInstance);
            instance.setClassLoader(classLoader);
            instance.setPlatformStorage(platformStorage);
            return (T)instance;
        }
        catch (InstantiationException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (ExceptionInInitializerError exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }
}

