/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatusReplyCallback;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import java.util.HashMap;
import java.util.Map;

public class AutoConfigurationAccessPointServiceCache
implements Shutdownable {
    private final AccessPointInfoDataset accessPointInfoDataset;
    private final Map<Integer, AccessPointService> services = new HashMap<Integer, AccessPointService>();
    private boolean finished = false;

    public AutoConfigurationAccessPointServiceCache(AccessPointInfoDataset accessPointInfoDataset) {
        this.accessPointInfoDataset = accessPointInfoDataset;
    }

    public void updateAccessPointInfo(AccessPointInfo accessPointInfo, ServiceAddress serviceAddress) throws InitializationException {
        AccessPointService accessPointService = this.getAccessPointService(accessPointInfo, serviceAddress);
        AccessPointServiceStatusReplyCallback callback = new AccessPointServiceStatusReplyCallback(accessPointInfo);
        accessPointService.queryServiceStatus((AccessPointReplyCallback)callback);
    }

    private AccessPointService getAccessPointService(AccessPointInfo accessPointInfo, ServiceAddress serviceAddress) throws InitializationException {
        AccessPointService accessPointService = this.accessPointInfoDataset.getService(accessPointInfo.getAccessPointId());
        if (accessPointService != null && this.isAddressEqual(accessPointService, serviceAddress)) {
            this.removeService(accessPointInfo.getAccessPointId());
        } else {
            accessPointService = this.getOrCreateService(accessPointInfo, serviceAddress);
        }
        return accessPointService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessPointService getOrCreateService(AccessPointInfo accessPointInfo, ServiceAddress serviceAddress) throws InitializationException {
        Map<Integer, AccessPointService> map = this.services;
        synchronized (map) {
            if (this.finished) {
                throw new InitializationException("Auto Configuration already stopped", new Object[0]);
            }
            if (this.services.containsKey(accessPointInfo.getAccessPointId()) && this.isAddressEqual(this.services.get(accessPointInfo.getAccessPointId()), serviceAddress)) {
                return this.services.get(accessPointInfo.getAccessPointId());
            }
            this.removeService(accessPointInfo.getAccessPointId());
            AccessPointServiceClient accessPointService = new AccessPointServiceClient(accessPointInfo.getAccessPointId().intValue(), serviceAddress, this.accessPointInfoDataset.getHttpConfiguration(), false, false);
            this.services.put(accessPointInfo.getAccessPointId(), (AccessPointService)accessPointService);
            return accessPointService;
        }
    }

    private boolean isAddressEqual(AccessPointService accessPointService, ServiceAddress serviceAddress) {
        return accessPointService.getServiceAddress().getConnectionString().equals(serviceAddress.getConnectionString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService(Integer accessPointId) {
        Map<Integer, AccessPointService> map = this.services;
        synchronized (map) {
            AccessPointService accessPointService = this.services.remove(accessPointId);
            if (accessPointService != null) {
                accessPointService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<Integer, AccessPointService> map = this.services;
        synchronized (map) {
            this.finished = true;
            for (AccessPointService service : this.services.values()) {
                service.shutdown();
            }
            this.services.clear();
        }
    }
}

