/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.roaming;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.Pin;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class RoamingEntry {
    private final LabelId labelId;
    private Pin pin;
    private int accessPointId;
    private DateTime roamingTime;

    public RoamingEntry(LabelId labelId, Pin pin) {
        this.labelId = labelId;
        this.pin = pin;
        this.accessPointId = 0;
        this.roamingTime = null;
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public Pin getPin() {
        return this.pin;
    }

    public boolean isAssigned() {
        return this.accessPointId != 0;
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public DateTime getJoinRequestTime() {
        return this.roamingTime;
    }

    public boolean update(int newAccessPointId, DateTime newRoamingTime) {
        if (this.accessPointId == 0) {
            this.accessPointId = newAccessPointId;
            this.roamingTime = newRoamingTime;
            return true;
        }
        if (newRoamingTime.isAfter((ReadableInstant)this.roamingTime)) {
            this.roamingTime = newRoamingTime;
        }
        if (this.accessPointId != newAccessPointId) {
            this.accessPointId = newAccessPointId;
            return true;
        }
        return false;
    }

    public void setPin(Pin pin) {
        this.pin = pin;
    }

    public boolean removePin() {
        if (this.pin != null) {
            this.pin = null;
            return true;
        }
        return false;
    }

    public boolean isExpired(int validForSeconds) {
        return this.getSecondsSinceJoinRequest().getSeconds() < validForSeconds;
    }

    public Seconds getSecondsSinceJoinRequest() {
        return Seconds.secondsBetween((ReadableInstant)this.roamingTime, (ReadableInstant)DateTime.now());
    }
}

