/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.roaming;

import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.roaming.RoamingEntry;
import at.mrdevelopment.esl.roaming.RoamingTableBuilder;
import at.mrdevelopment.esl.roaming.ThinInternalRoamingTable;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Strings;
import com.google.common.collect.ConcurrentHashMultiset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class DefaultRoamingTableBuilder
implements RoamingTableBuilder {
    static ESLLogger logger = ESLLogger.getLogger(DefaultRoamingTableBuilder.class);
    private final FeatureUnlock featureUnlock;
    private final Map<Integer, WirelessChannel> channelTable = new HashMap<Integer, WirelessChannel>();
    private final Map<LabelId, RoamingEntry> roamingEntries = new HashMap<LabelId, RoamingEntry>();
    private final Set<Address> registeredLabels = new ConcurrentSkipListSet<Address>();
    private final ConcurrentHashMultiset<WirelessChannel> usedChannels = ConcurrentHashMultiset.create();
    private final Map<Address, LabelType> labelTypes = new ConcurrentHashMap<Address, LabelType>(4096, 0.75f, 4);
    private final Map<Address, Pin> pins = new ConcurrentHashMap<Address, Pin>(4096, 0.75f, 4);
    private boolean modified = false;
    private DateTime lastModificationTime = DateTime.now();

    public DefaultRoamingTableBuilder(FeatureUnlock featureUnlock, Map<LabelId, RoamingEntry> initialRoamingEntries) {
        this.featureUnlock = featureUnlock;
        if (initialRoamingEntries != null && initialRoamingEntries.size() > 0) {
            this.roamingEntries.putAll(initialRoamingEntries);
            for (RoamingEntry re : initialRoamingEntries.values()) {
                Address address = re.getLabelId().toAddress();
                this.registeredLabels.add(address);
                this.labelTypes.put(address, re.getLabelId().getLabelType());
                if (re.getPin() == null) continue;
                this.pins.put(address, re.getPin());
            }
            this.modified = true;
        }
    }

    public synchronized void receivedWakeup(WakeupStatistic wakeupStatistic) {
        Address labelAddress = wakeupStatistic.getLabelAddress();
        LabelId labelId = new LabelId(labelAddress);
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        if (roamingEntry != null && !wakeupStatistic.isKeyUnset()) {
            this.pins.remove(labelAddress);
            this.modified |= roamingEntry.removePin();
        }
    }

    public synchronized void receivedJoinRequest(JoinRequest joinRequest) {
        Address labelAddress = joinRequest.getLabelAddress();
        LabelId labelId = new LabelId(labelAddress);
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        if (roamingEntry != null && joinRequest.isAccepted()) {
            int accessPointId = joinRequest.getAccessPointId();
            DateTime joinRequestTime = joinRequest.getTime();
            this.modified |= roamingEntry.update(accessPointId, joinRequestTime);
        }
    }

    @Override
    public synchronized void registerLabel(LabelId labelId, Pin pin) {
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        Address labelAddress = labelId.toAddress();
        if (roamingEntry == null) {
            roamingEntry = new RoamingEntry(labelId, pin);
            this.roamingEntries.put(labelId, roamingEntry);
            this.registeredLabels.add(labelAddress);
            this.labelTypes.put(labelAddress, labelId.getLabelType());
        } else {
            roamingEntry.setPin(pin);
        }
        if (pin != null) {
            this.pins.put(labelAddress, pin);
        }
        this.modified = true;
    }

    @Override
    public synchronized void unregisterLabel(LabelId labelId) {
        this.roamingEntries.remove(labelId);
        Address labelAddress = labelId.toAddress();
        this.registeredLabels.remove(labelAddress);
        this.labelTypes.remove(labelAddress);
        this.pins.remove(labelAddress);
        this.modified = true;
    }

    @Override
    public synchronized void addAccessPoint(int accessPointId, ServiceAddress serviceAddress, boolean isAutoConfig) {
        this.channelTable.put(accessPointId, null);
        this.modified = true;
    }

    @Override
    public synchronized void removeAccessPoint(int accessPointId) {
        this.channelTable.remove(accessPointId);
        this.modified = true;
    }

    @Override
    public synchronized boolean isModified() {
        return this.modified && Config.isRoamingTableResendImmediateIfModified() || Minutes.minutesBetween((ReadableInstant)this.lastModificationTime, (ReadableInstant)DateTime.now()).getMinutes() >= Config.getRoamingTableResendTimeInMinutes();
    }

    @Override
    public synchronized void resetModified() {
        this.lastModificationTime = DateTime.now();
        this.modified = false;
    }

    @Override
    public synchronized void updateChannelTable(AccessPointServiceStatus serviceStatus) {
        int accessPointId = serviceStatus.getAccessPointId();
        WirelessChannel newChannel = serviceStatus.getChannel();
        if (newChannel == null) {
            return;
        }
        WirelessChannel oldChannel = this.channelTable.get(accessPointId);
        if (newChannel != oldChannel) {
            if (oldChannel != null) {
                this.usedChannels.remove((Object)oldChannel);
            }
            this.channelTable.put(accessPointId, newChannel);
            this.usedChannels.add((Object)newChannel);
            this.modified = true;
        }
        if (!serviceStatus.hasValidRoamingTable()) {
            this.modified = true;
        }
    }

    @Override
    public synchronized RoamingTable getRoamingTable(int accessPointId) {
        ArrayList<ChannelTableEntry> accessPointEntries = new ArrayList<ChannelTableEntry>(this.channelTable.size());
        ArrayList<RoamingAssignment> roamingAssignments = new ArrayList<RoamingAssignment>(this.roamingEntries.size());
        for (Map.Entry<Integer, WirelessChannel> entry : this.channelTable.entrySet()) {
            int assignedAccessPointId = entry.getKey();
            WirelessChannel wirelessChannel = entry.getValue();
            if (wirelessChannel == null) continue;
            ChannelTableEntry accessPointEntry = new ChannelTableEntry(assignedAccessPointId, wirelessChannel);
            accessPointEntries.add(accessPointEntry);
        }
        for (RoamingEntry roamingEntry : this.roamingEntries.values()) {
            LabelId labelId = roamingEntry.getLabelId();
            int assignedAccessPointId = roamingEntry.getAccessPointId();
            Pin pin = roamingEntry.getPin();
            RoamingAssignment roamingAssignment = new RoamingAssignment(labelId.toAddress(), pin, labelId.getLabelType(), assignedAccessPointId);
            roamingAssignments.add(roamingAssignment);
        }
        int protocolId = this.featureUnlock.isUnrestrictedSyncAllowed() ? 0 : 1;
        int roamingTabelValidTimeInMinutes = Math.max(Config.getRoamingTableValidTimeInMinutes(), Config.getRoamingTableResendTimeInMinutes() + 5);
        int pingIntervalInMinutes = Config.getPingLabelsIntervalInMinutes();
        String passphrase = Config.getEncryptionPassphrase();
        boolean encryptionRequired = Config.isForceEncryption() ? true : !this.featureUnlock.isUnencryptedCommunicationAllowed();
        boolean allowBlacklistedLabels = this.featureUnlock.isLabelFromLegacyBlacklistAllowed();
        Key key = Strings.isNullOrEmpty((String)passphrase) ? null : Key.generateFromPassphrase((String)passphrase);
        SyncProfile syncProfile = SyncProfile.fromString((String)Config.getSyncProfile());
        return new RoamingTable(protocolId, roamingTabelValidTimeInMinutes, pingIntervalInMinutes, accessPointEntries, roamingAssignments, false, encryptionRequired, allowBlacklistedLabels, key, syncProfile);
    }

    @Override
    public synchronized ThinInternalRoamingTable getThinInternalRoamingTable(int accessPointId) {
        ThinInternalRoamingTable.Builder builder = new ThinInternalRoamingTable.Builder();
        ArrayList assignedLabelsBySlot = new ArrayList(1024);
        for (int slotId = 0; slotId < 1024; ++slotId) {
            assignedLabelsBySlot.add(slotId, new ArrayList(8));
        }
        HashSet<Address> assignedLabels = new HashSet<Address>();
        int assignedLabelsCount = 0;
        for (RoamingEntry roamingEntry : this.roamingEntries.values()) {
            if (roamingEntry.getAccessPointId() != accessPointId) continue;
            Address labelAddress = roamingEntry.getLabelId().toAddress();
            assignedLabels.add(labelAddress);
            ++assignedLabelsCount;
            ((ArrayList)assignedLabelsBySlot.get(labelAddress.getSlot())).add(labelAddress);
        }
        builder.assignedLabels(assignedLabels);
        builder.assignedLabelsCount(assignedLabelsCount);
        builder.assignedLabelsBySlot(assignedLabelsBySlot);
        builder.registeredLabels(this.registeredLabels);
        builder.labelTypes(this.labelTypes);
        builder.usedChannels(this.usedChannels.elementSet());
        builder.pins(this.pins);
        builder.protocolId(this.featureUnlock.isUnrestrictedSyncAllowed() ? 0 : 1);
        builder.updateTime(DateTime.now());
        builder.isValid(true);
        builder.validTimeInMinutes(Math.max(Config.getRoamingTableValidTimeInMinutes(), Config.getRoamingTableResendTimeInMinutes() + 5));
        builder.pingIntervalInMinutes(Config.getPingLabelsIntervalInMinutes());
        builder.remoteHostAddress("localhost");
        builder.remoteHostName("localhost");
        String passphrase = Config.getEncryptionPassphrase();
        builder.key(Strings.isNullOrEmpty((String)passphrase) ? null : Key.generateFromPassphrase((String)passphrase));
        builder.syncProfile(SyncProfile.fromString((String)Config.getSyncProfile()));
        builder.acceptAllLabels(false);
        builder.encryptionRequired(Config.isForceEncryption() ? true : !this.featureUnlock.isUnencryptedCommunicationAllowed());
        return builder.build();
    }

    @Override
    public synchronized int getAssignedAccessPoint(LabelId labelId) {
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        return roamingEntry != null ? roamingEntry.getAccessPointId() : 0;
    }

    @Override
    public synchronized void printRoamingTable() {
        if (logger.isInfoEnabled()) {
            HashMap<Integer, Integer> assignedLabels = new HashMap<Integer, Integer>();
            int unassignedLabelsCount = 0;
            for (RoamingEntry roamingEntry : this.roamingEntries.values()) {
                int accessPointId = roamingEntry.getAccessPointId();
                if (accessPointId != 0) {
                    Integer count = (Integer)assignedLabels.get(accessPointId);
                    assignedLabels.put(accessPointId, count == null ? 1 : count + 1);
                    continue;
                }
                ++unassignedLabelsCount;
            }
            logger.info("Roaming Table: %d unassigned labels", new Object[]{unassignedLabelsCount});
            for (Map.Entry entry : assignedLabels.entrySet()) {
                logger.info("Roaming Table: Access point %d has %d assigned labels", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    @Override
    public boolean isThinRoamingTableSupported() {
        return true;
    }
}

