/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.AbstractTransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.TaskUpdateTransaction;
import at.mrdevelopment.esl.server.WaitingTaskCache;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;

public class TaskUpdateTransactionSupplier
extends AbstractTransactionSupplier<TaskUpdateTransaction<?>> {
    private final int updateBatchSize;
    private final WaitingTaskCache waitingTaskCache;

    public static TaskUpdateTransactionSupplier fromTransactionSupplier(TransactionSupplier transactionSupplier, int updateBatchSize, WaitingTaskCache waitingTaskCache) {
        if (!(transactionSupplier instanceof AbstractTransactionSupplier)) {
            throw new IllegalArgumentException("Transaction supplier must be instance of AbstractTransactionSupplier");
        }
        return new TaskUpdateTransactionSupplier(((AbstractTransactionSupplier)transactionSupplier).getSessionFactory(), updateBatchSize, waitingTaskCache);
    }

    public TaskUpdateTransactionSupplier(SessionFactory sessionFactory, int updateBatchSize, WaitingTaskCache waitingTaskCache) {
        super(sessionFactory);
        this.updateBatchSize = updateBatchSize;
        this.waitingTaskCache = waitingTaskCache;
    }

    @Override
    public TaskUpdateTransaction<?> newTransaction() throws DatasetException {
        try {
            return new TaskUpdateTransaction(this.getSessionFactory(), this.updateBatchSize, this.waitingTaskCache);
        }
        catch (HibernateException exc) {
            throw new DatasetException((Throwable)exc);
        }
    }
}

