/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.server.WaitingTaskCache;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class TaskUpdateTransaction<UNUSED>
extends ORMTransaction<UNUSED> {
    private final SessionFactory sessionFactory;
    private final int updateBatchSize;
    private int currentBatchSize = 0;
    private final WaitingTaskCache waitingTaskCache;
    private final Set<UpdateStatus> updates = new LinkedHashSet<UpdateStatus>();

    public TaskUpdateTransaction(SessionFactory sessionFactory, int updateBatchSize, WaitingTaskCache waitingTaskCache) throws DatasetException {
        super((Session)sessionFactory.getCurrentSession());
        this.waitingTaskCache = waitingTaskCache;
        this.updateBatchSize = updateBatchSize;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void saveOrUpdate(Object record) throws DatasetException {
        super.saveOrUpdate(record);
        if (this.isRecordRelevant(record)) {
            this.updates.add((UpdateStatus)record);
            ++this.currentBatchSize;
            this.checkBatchSize();
        }
    }

    @Override
    public void save(Object record) throws DatasetException {
        super.save(record);
        if (this.isRecordRelevant(record)) {
            this.updates.add((UpdateStatus)record);
            ++this.currentBatchSize;
            this.checkBatchSize();
        }
    }

    @Override
    public void update(Object record) throws DatasetException {
        super.update(record);
        if (this.isRecordRelevant(record)) {
            this.updates.add((UpdateStatus)record);
            ++this.currentBatchSize;
            this.checkBatchSize();
        }
    }

    @Override
    public void commit() throws DatasetException {
        super.commit();
        this.waitingTaskCache.updateStructures(this.updates);
        this.updates.clear();
    }

    @Override
    public void rollback() throws DatasetException {
        super.rollback();
        this.updates.clear();
    }

    private boolean isRecordRelevant(Object record) {
        return record instanceof UpdateStatus;
    }

    private void checkBatchSize() throws DatasetException {
        if (this.currentBatchSize % this.updateBatchSize == 0) {
            try {
                this.commit();
            }
            catch (DatasetException exc) {
                this.rollback();
                throw exc;
            }
            this.startTransaction((Session)this.sessionFactory.getCurrentSession());
        }
    }
}

