/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.BatchQueryCallback;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;

public class ORMTransaction<UNUSED>
implements Transaction<UNUSED> {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    static ESLLogger logger = ESLLogger.getLogger(ORMTransaction.class);
    private Session session;
    private org.hibernate.Transaction hibernateTransaction;

    public static ORMTransaction<?> fromTransaction(Transaction<?> transaction) {
        return (ORMTransaction)transaction;
    }

    public ORMTransaction(Session session) throws DatasetException {
        this.startTransaction(session);
    }

    protected void startTransaction(Session session) throws DatasetException {
        try {
            this.session = session;
            this.hibernateTransaction = session.beginTransaction();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public void commit() throws DatasetException {
        try {
            this.hibernateTransaction.commit();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public void rollback() throws DatasetException {
        try {
            if (this.hibernateTransaction.isActive()) {
                this.hibernateTransaction.rollback();
            }
        }
        catch (Exception exc) {
            logger.warn("Could not rollback transaction: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    public void closeSession() throws DatasetException {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                throw new DatasetException((Throwable)exception);
            }
        }
    }

    public Query createSQLQuery(String queryString, Class<?> entityClass) throws DatasetException {
        try {
            return this.session.createSQLQuery(queryString).addEntity(entityClass);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Query createSQLQuery(String queryString) throws DatasetException {
        try {
            return this.session.createSQLQuery(queryString);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Query createQuery(String queryString) throws DatasetException {
        try {
            return this.session.createQuery(queryString);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Criteria createCriteria(Class<?> recordClass) throws DatasetException {
        try {
            return this.session.createCriteria(recordClass);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public <T> List<T> query(Query query, Class<T> recordClass) throws DatasetException {
        try {
            return query.list();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public <T> List<T> query(Criteria criteria, Class<?> recordClass) throws DatasetException {
        try {
            List result = criteria.list();
            return result;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public <T> int batchQuery(Query query, int batchSize, BatchQueryCallback<T> callback) throws DatasetException {
        int recordCount = 0;
        ArrayList<Object> records = null;
        ScrollableResults cursor = null;
        try {
            cursor = query.scroll();
            while (cursor.next()) {
                if (records == null) {
                    records = new ArrayList<Object>();
                }
                Object record = cursor.get(0);
                ++recordCount;
                records.add(record);
                if (records.size() % batchSize != 0) continue;
                callback.recordsQueried(records);
                records = null;
            }
            if (records != null && records.size() > 0) {
                callback.recordsQueried(records);
                records = null;
            }
            this.tryCloseCursor(cursor);
            cursor = null;
            int record = recordCount;
            return record;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
        finally {
            this.tryCloseCursor(cursor);
        }
    }

    public <C> int batchQuery(Criteria criteria, int batchSize, BatchQueryCallback<C> callback) throws DatasetException {
        int recordCount = 0;
        List records = null;
        criteria.setMaxResults(batchSize);
        try {
            while ((records = criteria.list()).size() > 0) {
                callback.recordsQueried(records);
                criteria.setFirstResult(recordCount += records.size());
                this.session.flush();
            }
            return recordCount;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public int deleteFromQuery(Criteria criteria) throws DatasetException {
        return this.deleteFromQuery(criteria, 1000);
    }

    public int deleteFromQuery(Criteria criteria, int batchSize) throws DatasetException {
        ScrollableResults cursor = null;
        try {
            int deletedRows = 0;
            cursor = criteria.scroll();
            while (cursor.next()) {
                Object record = cursor.get(0);
                this.session.delete(record);
                if (++deletedRows % batchSize != 0) continue;
                logger.debug("Deleted batch of %d rows (total %d rows)", new Object[]{batchSize, deletedRows});
                this.session.flush();
            }
            this.tryCloseCursor(cursor);
            cursor = null;
            int n = deletedRows;
            return n;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
        finally {
            this.tryCloseCursor(cursor);
        }
    }

    public int deleteFromQuery(Query query) throws DatasetException {
        return this.deleteFromQuery(query, 1000);
    }

    public int deleteFromQuery(Query query, int batchSize) throws DatasetException {
        ScrollableResults cursor = null;
        try {
            int deletedRows = 0;
            cursor = query.scroll();
            while (cursor.next()) {
                Object record = cursor.get(0);
                this.session.delete(record);
                if (++deletedRows % batchSize != 0) continue;
                logger.debug("Deleted batch of %d rows (total %d rows)", new Object[]{batchSize, deletedRows});
                this.session.flush();
            }
            this.tryCloseCursor(cursor);
            cursor = null;
            int n = deletedRows;
            return n;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
        finally {
            this.tryCloseCursor(cursor);
        }
    }

    public <T> T querySingleRow(Query query, Class<T> recordClass) throws DatasetException {
        try {
            Object result = query.uniqueResult();
            return recordClass.cast(result);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public int queryCount(Query countQuery) throws DatasetException {
        try {
            int count = ((Number)countQuery.uniqueResult()).intValue();
            return count;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public int executeUpdate(Query updateQuery) throws DatasetException {
        try {
            int updatedRows = updateQuery.executeUpdate();
            return updatedRows;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Session getSession() {
        return this.session;
    }

    private void tryCloseCursor(ScrollableResults cursor) throws DatasetException {
        if (this.session != null && this.session.isOpen() && cursor != null) {
            try {
                cursor.close();
                cursor = null;
            }
            catch (Exception exc) {
                throw new DatasetException((Throwable)exc);
            }
        }
    }

    public boolean isCommitted() {
        return this.hibernateTransaction.wasCommitted();
    }

    public void saveOrUpdate(Object record) throws DatasetException {
        this.session.saveOrUpdate(record);
    }

    public void save(Object record) throws DatasetException {
        this.session.save(record);
    }

    public void delete(Object record) throws DatasetException {
        this.session.delete(record);
    }

    public void update(Object record) throws DatasetException {
        this.session.update(record);
    }

    public void refresh(Object record) throws DatasetException {
        this.session.refresh(record);
    }

    public void clear() throws DatasetException {
        this.session.clear();
    }

    public <T> T merge(T record) throws DatasetException {
        return (T)this.session.merge(record);
    }
}

