/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class BatchUpdateORMTransaction<UNUSED>
extends ORMTransaction<UNUSED> {
    private final SessionFactory sessionFactory;
    private final int updateBatchSize;
    private int currentBatchSize = 0;

    public BatchUpdateORMTransaction(SessionFactory sessionFactory, int updateBatchSize) throws DatasetException {
        super((Session)sessionFactory.getCurrentSession());
        this.sessionFactory = sessionFactory;
        this.updateBatchSize = updateBatchSize;
    }

    private void checkBatchSize() throws DatasetException {
        if (this.currentBatchSize % this.updateBatchSize == 0) {
            try {
                this.commit();
            }
            catch (DatasetException exc) {
                this.rollback();
                throw exc;
            }
            this.startTransaction((Session)this.sessionFactory.getCurrentSession());
        }
    }

    @Override
    public void saveOrUpdate(Object record) throws DatasetException {
        super.saveOrUpdate(record);
        ++this.currentBatchSize;
        this.checkBatchSize();
    }

    @Override
    public void save(Object record) throws DatasetException {
        super.save(record);
        ++this.currentBatchSize;
        this.checkBatchSize();
    }

    @Override
    public void delete(Object record) throws DatasetException {
        super.delete(record);
        ++this.currentBatchSize;
        this.checkBatchSize();
    }

    @Override
    public void update(Object record) throws DatasetException {
        super.update(record);
        ++this.currentBatchSize;
        this.checkBatchSize();
    }

    @Override
    public <T> T merge(T record) throws DatasetException {
        T merged = super.merge(record);
        ++this.currentBatchSize;
        this.checkBatchSize();
        return merged;
    }
}

