/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.AbstractUpdateStatusQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class UpdatesForLabelQuery
extends AbstractUpdateStatusQuery<LabelId> {
    private static final String QUERY = "from UpdateStatus u where u.taskRecord.label = :label and ";

    public UpdatesForLabelQuery(ORMDataset<UpdateStatus> dataset) throws DatasetException {
        super(dataset, "updatestatus/label", QUERY, LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select u " + this.getBaseQuery() + " order by u.id").setLong("label", labelId.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(u) " + this.getBaseQuery()).setLong("label", labelId.getId());
    }
}

