/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.AbstractUpdateStatusQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class UpdatesForExternalIdQuery
extends AbstractUpdateStatusQuery<Long> {
    private static final String QUERY = "from UpdateStatus u where u.taskRecord.externalId = :externalId and ";

    public UpdatesForExternalIdQuery(ORMDataset<UpdateStatus> dataset) throws DatasetException {
        super(dataset, "updatestatus/externalid", QUERY, Long.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<Long> queryRestriction) throws DatasetException {
        long externalId = this.getExternalId((Long)queryRestriction.getSearchKey());
        return transaction.createQuery("select u " + this.getBaseQuery() + " order by u.id").setParameter("externalId", (Object)externalId);
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<Long> queryRestriction) throws DatasetException {
        long externalId = this.getExternalId((Long)queryRestriction.getSearchKey());
        return transaction.createQuery("select count(u) " + this.getBaseQuery()).setParameter("externalId", (Object)externalId);
    }

    private long getExternalId(long externalId) {
        if (externalId <= 0L) {
            throw new IllegalArgumentException(String.format("%d is not a legal external id", externalId));
        }
        return externalId;
    }
}

