/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.type.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TagsQuery
extends DefaultQuery<Tag, Void> {
    private final Dataset<LabelInfo> dataset;

    public TagsQuery(Dataset<LabelInfo> dataset) {
        super("tags", Tag.class, Void.class);
        this.dataset = dataset;
    }

    @Override
    protected List<Tag> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            for (String tag : labelInfo.getTags()) {
                tags.add(new Tag(tag));
            }
        }
        return Collections.unmodifiableList(new ArrayList(tags));
    }
}

