/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.AbstractDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import java.util.List;
import org.hibernate.Query;

public abstract class ORMDatasetQuery<T extends Record, S>
extends AbstractDatasetQuery<T, S> {
    protected final ORMDataset<T> dataset;
    private final String url;
    private final Class<S> parameterClass;
    private final boolean singleRecordExpected;

    public ORMDatasetQuery(ORMDataset<T> dataset, String url, Class<S> parameterClass) throws DatasetException {
        this(dataset, url, parameterClass, false);
    }

    public ORMDatasetQuery(ORMDataset<T> dataset, String url, Class<S> parameterClass, boolean singleRecordExpected) throws DatasetException {
        this.dataset = dataset;
        this.url = url;
        this.parameterClass = parameterClass;
        this.singleRecordExpected = singleRecordExpected;
    }

    public String getUrl() {
        return this.url;
    }

    public Class<T> getRecordClass() {
        return this.dataset.getRecordClass();
    }

    public List<String> getCustomFields() {
        return this.dataset.getCustomFields();
    }

    public Class<S> getParameterClass() {
        return this.parameterClass;
    }

    public boolean isSingleRecordExpected() {
        return this.singleRecordExpected;
    }

    public QueryResult<T> getResult(QueryRestriction<S> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        if (queryRestriction.isPagedResults()) {
            Query query = this.getQuery(ormTransaction, queryRestriction).setFirstResult(queryRestriction.getPage() * queryRestriction.getRecordsPerPage()).setMaxResults(queryRestriction.getRecordsPerPage().intValue());
            Query countQuery = this.getCountQuery(ormTransaction, queryRestriction);
            int totalRecords = ((Number)countQuery.uniqueResult()).intValue();
            List<T> results = ormTransaction.query(query, this.getRecordClass());
            return QueryResult.newPagedResult(results, (int)totalRecords, (int)queryRestriction.getPage(), (int)queryRestriction.getRecordsPerPage());
        }
        Query query = this.getQuery(ormTransaction, queryRestriction);
        List<T> results = ormTransaction.query(query, this.getRecordClass());
        return QueryResult.newUnpagedResult(results);
    }

    public int getCount(QueryRestriction<S> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        return ormTransaction.queryCount(this.getCountQuery(ormTransaction, queryRestriction));
    }

    protected abstract Query getQuery(ORMTransaction<?> var1, QueryRestriction<S> var2) throws DatasetException;

    protected abstract Query getCountQuery(ORMTransaction<?> var1, QueryRestriction<S> var2) throws DatasetException;
}

