/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.type.LabelDetailType;
import org.hibernate.Query;

public class LatestCountersForLabelQuery
extends ORMDatasetQuery<LabelDetail, LabelId> {
    private static final String QUERY = "from LabelDetail d where d.label = :label and d.type = '" + LabelDetailType.QUERY_COUNTER.name() + "' and d.value is not null and d.id in (select max(dd.id) from LabelDetail dd where dd.label = :label and dd.type = '" + LabelDetailType.QUERY_COUNTER.name() + "' and dd.value is not null group by dd.dataId)";

    public LatestCountersForLabelQuery(ORMDataset<LabelDetail> dataset) throws DatasetException {
        super(dataset, "labeldetail/counter/latest/label", LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select d " + QUERY + " order by d.id").setLong("label", labelId.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(d) " + QUERY).setLong("label", labelId.getId());
    }
}

