/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelsWithoutEncryptionQuery
extends DefaultDatasetQuery<LabelInfo, Void> {
    public LabelsWithoutEncryptionQuery(LabelInfoDataset dataset) {
        super(dataset, "labelinfo/noencryption", Void.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<LabelInfo> labelsWithoutEncryption = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            SecurityStatus securityStatus = labelInfo.getSecurityStatus();
            if (securityStatus == null || !securityStatus.isEncryptionSupported() || securityStatus.isEncrypted()) continue;
            labelsWithoutEncryption.add(labelInfo);
        }
        return Collections.unmodifiableList(labelsWithoutEncryption);
    }
}

