/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelsWithRssiHigherQuery
extends DefaultDatasetQuery<LabelInfo, Integer> {
    public LabelsWithRssiHigherQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/rssi/higher", Integer.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<Integer> queryRestriction, Transaction<?> transaction) throws DatasetException {
        Integer rssi = (Integer)queryRestriction.getSearchKey();
        ArrayList<LabelInfo> labelsWithStatus = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getRssi() == null || labelInfo.getRssi() <= rssi) continue;
            labelsWithStatus.add(labelInfo);
        }
        return Collections.unmodifiableList(labelsWithStatus);
    }
}

