/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.UpdateInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelsWithProblemsQuery
extends DefaultDatasetQuery<LabelInfo, Void> {
    public LabelsWithProblemsQuery(LabelInfoDataset dataset) {
        super(dataset, "labelinfo/problem", Void.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<LabelInfo> labelsWithProblems = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            UpdateInfo updateInfo = labelInfo.getUpdateInfo();
            if (labelInfo == null || !(labelInfo.getConnectionStatus() != null && labelInfo.getConnectionStatus().isOffline() || labelInfo.getLabelErrors() != null && labelInfo.getLabelErrors().hasErrors() || labelInfo.getPowerStatus() != null && (labelInfo.getPowerStatus().isLow() || labelInfo.getPowerStatus().isBad())) && (updateInfo == null || updateInfo.getStatus() == null || !updateInfo.getStatus().isUnsuccessful())) continue;
            labelsWithProblems.add(labelInfo);
        }
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            Status status;
            ConnectionStatus connectionStatus = labelInfo.getConnectionStatus();
            LabelErrors labelErrors = labelInfo.getLabelErrors();
            PowerStatus powerStatus = labelInfo.getPowerStatus();
            UpdateInfo updateInfo = labelInfo.getUpdateInfo();
            Status status2 = status = updateInfo != null ? updateInfo.getStatus() : null;
            if (!(connectionStatus != null && connectionStatus.isOffline() || labelErrors != null && labelErrors.hasErrors() || powerStatus != null && powerStatus.isLowOrBad()) && (status == null || !status.isUnsuccessful())) continue;
            labelsWithProblems.add(labelInfo);
        }
        return Collections.unmodifiableList(labelsWithProblems);
    }
}

