/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LinkQuality;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelsWithLinkQualityQuery
extends DefaultDatasetQuery<LabelInfo, LinkQuality> {
    public LabelsWithLinkQualityQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/syncquality", LinkQuality.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<LinkQuality> queryRestriction, Transaction<?> transaction) throws DatasetException {
        LinkQuality status = (LinkQuality)queryRestriction.getSearchKey();
        ArrayList<LabelInfo> labelsWithStatus = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getSyncQuality() == null || labelInfo.getSyncQuality().getSyncQualityLevel() != status) continue;
            labelsWithStatus.add(labelInfo);
        }
        return Collections.unmodifiableList(labelsWithStatus);
    }
}

