/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.PredefinedDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelsWithConnectionStatusQuery
extends DefaultDatasetQuery<LabelInfo, ConnectionStatus> {
    public static DatasetQuery<LabelInfo, Void> newOfflineLabelsQuery(Dataset<LabelInfo> dataset) {
        LabelsWithConnectionStatusQuery query = new LabelsWithConnectionStatusQuery(dataset);
        return new PredefinedDatasetQuery(query, ConnectionStatus.OFFLINE);
    }

    public static DatasetQuery<LabelInfo, Void> newUnknownLabelsQuery(Dataset<LabelInfo> dataset) {
        LabelsWithConnectionStatusQuery query = new LabelsWithConnectionStatusQuery(dataset);
        return new PredefinedDatasetQuery(query, ConnectionStatus.UNKNOWN);
    }

    public LabelsWithConnectionStatusQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/status", ConnectionStatus.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<ConnectionStatus> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ConnectionStatus status = (ConnectionStatus)queryRestriction.getSearchKey();
        ArrayList<LabelInfo> labelsWithStatus = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getConnectionStatus() != status) continue;
            labelsWithStatus.add(labelInfo);
        }
        return Collections.unmodifiableList(labelsWithStatus);
    }
}

