/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelsUpdatedAfterQuery
extends DefaultDatasetQuery<LabelInfo, DateTime> {
    public LabelsUpdatedAfterQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/updatedafter", DateTime.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<DateTime> queryRestriction, Transaction<?> transaction) throws DatasetException {
        DateTime queryTime = (DateTime)queryRestriction.getSearchKey();
        ArrayList<LabelInfo> labels = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getLastUpdateTime() == null || !labelInfo.getLastUpdateTime().isAfter((ReadableInstant)queryTime)) continue;
            labels.add(labelInfo);
        }
        return Collections.unmodifiableList(labels);
    }
}

