/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelsNotSeenForMinutesQuery
extends DefaultDatasetQuery<LabelInfo, Integer> {
    public LabelsNotSeenForMinutesQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/notseenforminutes", Integer.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<Integer> queryRestriction, Transaction<?> transaction) throws DatasetException {
        int minutes = Math.max(0, (Integer)queryRestriction.getSearchKey());
        ArrayList<LabelInfo> labels = new ArrayList<LabelInfo>();
        DateTime queryTime = new DateTime().minusMinutes(minutes);
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getWakeupTime() == null || !labelInfo.getWakeupTime().isBefore((ReadableInstant)queryTime)) continue;
            labels.add(labelInfo);
        }
        return Collections.unmodifiableList(labels);
    }
}

