/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.DefaultLabelTypeMapping;
import at.mrdevelopment.esl.core.labeltype.DisplayColors;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

public class LabelTypeQuery
extends DefaultQuery<LabelTypeDescription, Void> {
    public LabelTypeQuery() {
        super("description/labeltype", LabelTypeDescription.class, Void.class);
    }

    @Override
    protected List<LabelTypeDescription> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        Collection nonHiddenLabelTypes = CollectionUtils.select(Arrays.asList(LabelType.values()), (Predicate)new Predicate<LabelType>(){

            public boolean evaluate(LabelType labelType) {
                return !labelType.isHidden();
            }
        });
        List labelTypeDescriptions = (List)CollectionUtils.collect((Iterable)nonHiddenLabelTypes, (Transformer)new Transformer<LabelType, LabelTypeDescription>(){

            public LabelTypeDescription transform(LabelType labelType) {
                return new LabelTypeDescription(labelType);
            }
        }, new ArrayList(nonHiddenLabelTypes.size()));
        return Lists.newArrayList((Iterable)CollectionUtils.select((Collection)labelTypeDescriptions, (Predicate)new Predicate<LabelTypeDescription>(){

            public boolean evaluate(LabelTypeDescription labelTypeDescription) {
                return !labelTypeDescription.getMappings().isEmpty();
            }
        }));
    }

    public static class LabelTypeDescription {
        private final LabelType labelType;

        public LabelTypeDescription(LabelType labelType) {
            this.labelType = labelType;
        }

        @Serialize
        public String getName() {
            return this.labelType.getName();
        }

        @Serialize
        public int getDisplayWidth() {
            return this.labelType.getDisplayWidth();
        }

        @Serialize
        public int getDisplayHeight() {
            return this.labelType.getDisplayHeight();
        }

        @Serialize
        public int getDisplayDpi() {
            return this.labelType.getDisplayDpi();
        }

        @Serialize
        public LabelType.DisplayTechnology getDisplayTechnology() {
            return this.labelType.getDisplayTechnology();
        }

        @Serialize
        public DisplayColors getDisplayColors() {
            return this.labelType.getDisplayColors();
        }

        @Serialize
        public LabelType.PowerSource getPowerSource() {
            return this.labelType.getPowerSource();
        }

        @Serialize
        public int getAvailablePageCount() {
            return this.labelType.getAvailablePageCount();
        }

        @Serialize
        public Set<LabelType.HardwareFeature> getHardwareFeatures() {
            return this.labelType.getHardwareFeatures();
        }

        @Serialize
        public Set<String> getMappings() {
            return (Set)CollectionUtils.collect((Iterable)DefaultLabelTypeMapping.getCodesForType((LabelType)this.labelType), (Transformer)new Transformer<Integer, String>(){

                public String transform(Integer code) {
                    return String.format("%02X", code);
                }
            }, new HashSet());
        }
    }
}

