/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import java.util.UUID;
import org.hibernate.Query;

public class LabelDataForTaskQuery
extends ORMDatasetQuery<LabelDetail, UUID> {
    private static final String QUERY = "from LabelDetail d where d.taskId = :taskId and d.value is not null";

    public LabelDataForTaskQuery(ORMDataset<LabelDetail> dataset) throws DatasetException {
        super(dataset, "labeldetail/task", UUID.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<UUID> queryRestriction) throws DatasetException {
        UUID taskId = (UUID)queryRestriction.getSearchKey();
        return transaction.createQuery("select d from LabelDetail d where d.taskId = :taskId and d.value is not null order by d.id").setParameter("taskId", (Object)taskId);
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<UUID> queryRestriction) throws DatasetException {
        UUID taskId = (UUID)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(d) from LabelDetail d where d.taskId = :taskId and d.value is not null").setParameter("taskId", (Object)taskId);
    }
}

