/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.AbstractDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.query.ScrollableQueryResult;
import java.util.Collections;
import java.util.List;

public abstract class DefaultQuery<T, S>
extends AbstractDatasetQuery<T, S> {
    private final String url;
    private final Class<T> recordClass;
    private final Class<S> parameterClass;
    private final boolean singleRecordExpected;

    public DefaultQuery(String url, Class<T> recordClass, Class<S> parameterClass) {
        this(url, recordClass, parameterClass, false);
    }

    public DefaultQuery(String url, Class<T> recordClass, Class<S> parameterClass, boolean singleRecordExpected) {
        this.url = url;
        this.recordClass = recordClass;
        this.parameterClass = parameterClass;
        this.singleRecordExpected = singleRecordExpected;
    }

    public String getUrl() {
        return this.url;
    }

    public Class<T> getRecordClass() {
        return this.recordClass;
    }

    public List<String> getCustomFields() {
        return Collections.emptyList();
    }

    public Class<S> getParameterClass() {
        return this.parameterClass;
    }

    public boolean isSingleRecordExpected() {
        return this.singleRecordExpected;
    }

    public QueryResult<T> getResult(QueryRestriction<S> queryRestriction, Transaction<?> transaction) throws DatasetException {
        List<T> records = this.getRecords(queryRestriction, transaction);
        if (queryRestriction.isPagedResults()) {
            return new ScrollableQueryResult(records).getResultsForPage(queryRestriction.getPage().intValue(), queryRestriction.getRecordsPerPage().intValue());
        }
        return QueryResult.newUnpagedResult(records);
    }

    public int getCount(QueryRestriction<S> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return this.getResult(queryRestriction, transaction).getTotalRecords();
    }

    protected abstract List<T> getRecords(QueryRestriction<S> var1, Transaction<?> var2) throws DatasetException;
}

