/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.BatteryReplacementRecord;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class BatteryReplacementForLabelQuery
extends ORMDatasetQuery<BatteryReplacementRecord, LabelId> {
    private static final String QUERY = "from BatteryReplacementRecord b where b.label = :label";

    public BatteryReplacementForLabelQuery(ORMDataset<BatteryReplacementRecord> dataset) throws DatasetException {
        super(dataset, "batteryreplacement/label", LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId label = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select b from BatteryReplacementRecord b where b.label = :label order by b.id").setLong("label", label.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId label = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(b) from BatteryReplacementRecord b where b.label = :label").setParameter("label", (Object)label.getId());
    }
}

