/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessPointsWithoutChannelQuery
extends DefaultDatasetQuery<AccessPointInfo, Void> {
    public AccessPointsWithoutChannelQuery(Dataset<AccessPointInfo> dataset) {
        super(dataset, "accesspointinfo/nochannel", Void.class);
    }

    @Override
    protected List<AccessPointInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<AccessPointInfo> noChannelAccessPoints = new ArrayList<AccessPointInfo>();
        for (AccessPointInfo accessPointInfo : this.dataset.queryAll(transaction)) {
            if (!accessPointInfo.isOnline() || accessPointInfo.getChannel() != null) continue;
            noChannelAccessPoints.add(accessPointInfo);
        }
        return Collections.unmodifiableList(noChannelAccessPoints);
    }
}

