/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.PredefinedDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessPointsWithConnectionStatusQuery
extends DefaultDatasetQuery<AccessPointInfo, ConnectionStatus> {
    public static PredefinedDatasetQuery<AccessPointInfo, ConnectionStatus> newOfflineAccessPointsQuery(Dataset<AccessPointInfo> dataset) {
        AccessPointsWithConnectionStatusQuery query = new AccessPointsWithConnectionStatusQuery(dataset);
        return new PredefinedDatasetQuery<AccessPointInfo, ConnectionStatus>((DatasetQuery<AccessPointInfo, ConnectionStatus>)query, ConnectionStatus.OFFLINE);
    }

    public AccessPointsWithConnectionStatusQuery(Dataset<AccessPointInfo> dataset) {
        super(dataset, "accesspointinfo/status", ConnectionStatus.class);
    }

    @Override
    protected List<AccessPointInfo> getRecords(QueryRestriction<ConnectionStatus> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ConnectionStatus status = (ConnectionStatus)queryRestriction.getSearchKey();
        ArrayList<AccessPointInfo> offlineAccessPoints = new ArrayList<AccessPointInfo>();
        for (AccessPointInfo accessPointInfo : this.dataset.queryAll(transaction)) {
            if (accessPointInfo.getConnectionStatus() != status) continue;
            offlineAccessPoints.add(accessPointInfo);
        }
        return Collections.unmodifiableList(offlineAccessPoints);
    }
}

