/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class AccessPointsWithChannelConflictQuery
extends DefaultDatasetQuery<AccessPointInfo, Void> {
    public AccessPointsWithChannelConflictQuery(Dataset<AccessPointInfo> dataset) {
        super(dataset, "accesspointinfo/channelconflict", Void.class);
    }

    @Override
    protected List<AccessPointInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        HashMap channels = new HashMap();
        for (AccessPointInfo accessPointInfo : this.dataset.queryAll(transaction)) {
            if (!accessPointInfo.isOnline() || accessPointInfo.getChannel() == null) continue;
            if (!channels.containsKey(accessPointInfo.getChannel())) {
                channels.put(accessPointInfo.getChannel(), new LinkedList());
            }
            ((Collection)channels.get(accessPointInfo.getChannel())).add(accessPointInfo);
        }
        ArrayList duplicateChannelAccessPoints = new ArrayList();
        for (WirelessChannel channel : channels.keySet()) {
            if (((Collection)channels.get(channel)).size() <= 1) continue;
            duplicateChannelAccessPoints.addAll((Collection)channels.get(channel));
        }
        return Collections.unmodifiableList(duplicateChannelAccessPoints);
    }
}

