/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.toolkit.Version;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessPointWithoutEncryptionSupportQuery
extends DefaultDatasetQuery<AccessPointInfo, Void> {
    private static final Version securitySupportedVersion = Version.fromString((String)"1.3.0");

    public AccessPointWithoutEncryptionSupportQuery(Dataset<AccessPointInfo> dataset) {
        super(dataset, "accesspointinfo/noencryption", Void.class);
    }

    @Override
    protected List<AccessPointInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<AccessPointInfo> noEncryptionAccessPoints = new ArrayList<AccessPointInfo>();
        if (!Strings.isNullOrEmpty((String)Config.getEncryptionPassphrase())) {
            for (AccessPointInfo accessPointInfo : this.dataset.queryAll(transaction)) {
                Version version = accessPointInfo.getVersion();
                if (!accessPointInfo.isOnline() || version == null || !version.isOlder(securitySupportedVersion)) continue;
                noEncryptionAccessPoints.add(accessPointInfo);
            }
        }
        return Collections.unmodifiableList(noEncryptionAccessPoints);
    }
}

