/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.configuration.ConfigurationChangedListener;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.job.TimeBasedConfigurationJob;
import at.mrdevelopment.esl.persistence.maintenance.job.TimeBasedConfigurationProfile;
import at.mrdevelopment.esl.persistence.maintenance.job.TimeBasedJobConfiguration;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.server.ServiceScheduler;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class TimebasedConfigurationJobFactory
implements ConfigurationChangedListener {
    static ESLLogger logger = ESLLogger.getLogger(TimebasedConfigurationJobFactory.class);
    private static final String CONFIG_KEY = "timeBasedConfigurationJobs";
    private final Map<TimeBasedConfigurationProfile, Long> currentConfigurations = new HashMap<TimeBasedConfigurationProfile, Long>();
    private final ServiceScheduler serviceScheduler;
    private final AtomicLong configurationId = new AtomicLong();

    public TimebasedConfigurationJobFactory(ServiceScheduler serviceScheduler, ConfigurationDataset configurationDataset, Transaction<?> transaction) throws InitializationException {
        this.serviceScheduler = serviceScheduler;
        try {
            Configuration configuration = configurationDataset.getConfiguration(CONFIG_KEY, transaction);
            this.rescheduleJobs(configuration.getValue(), transaction);
        }
        catch (Exception exception) {
            logger.warn("Could not load time based configuration: %s", new Object[]{exception.getMessage()});
            logger.logException((Throwable)exception);
        }
    }

    @Override
    public void configurationChanged(String key, String value, Transaction<?> transaction) throws Exception {
        if (CONFIG_KEY.equals(key)) {
            this.rescheduleJobs(value, transaction);
        }
    }

    private synchronized void rescheduleJobs(String configurationString, Transaction<?> transaction) {
        Collection<TimeBasedConfigurationProfile> newTimeBasedConfigurationProfiles = TimeBasedConfigurationProfile.fromConfigurationString(configurationString);
        this.removeUnusedJobs(newTimeBasedConfigurationProfiles);
        this.addNewJobs(newTimeBasedConfigurationProfiles, transaction);
    }

    private void removeUnusedJobs(Collection<TimeBasedConfigurationProfile> newTimeBasedConfigurationProfiles) {
        Iterator<Map.Entry<TimeBasedConfigurationProfile, Long>> currentConfigurationsIterator = this.currentConfigurations.entrySet().iterator();
        while (currentConfigurationsIterator.hasNext()) {
            Map.Entry<TimeBasedConfigurationProfile, Long> currentConfigurationEntry = currentConfigurationsIterator.next();
            TimeBasedConfigurationProfile currentConfiguration = currentConfigurationEntry.getKey();
            if (newTimeBasedConfigurationProfiles.contains(currentConfiguration)) continue;
            this.serviceScheduler.unregisterJob(this.generateJobName(currentConfigurationEntry.getValue()));
            currentConfigurationsIterator.remove();
        }
    }

    private void addNewJobs(Collection<TimeBasedConfigurationProfile> newTimeBasedConfigurationProfiles, Transaction<?> transaction) {
        for (TimeBasedConfigurationProfile newTimeBasedConfigurationProfile : newTimeBasedConfigurationProfiles) {
            if (this.currentConfigurations.keySet().contains(newTimeBasedConfigurationProfile)) continue;
            long newConfigurationId = this.configurationId.getAndIncrement();
            String jobIdentifier = this.generateJobName(newConfigurationId);
            HashMap<String, Object> additionalData = new HashMap<String, Object>();
            additionalData.put("configurationKey", newTimeBasedConfigurationProfile.getKey());
            additionalData.put("configurationValue", newTimeBasedConfigurationProfile.getValue());
            additionalData.put("jobIdentifier", jobIdentifier);
            this.serviceScheduler.registerJob(new TimeBasedJobConfiguration(TimeBasedConfigurationJob.class, jobIdentifier, newTimeBasedConfigurationProfile), additionalData, transaction);
            this.currentConfigurations.put(newTimeBasedConfigurationProfile, newConfigurationId);
        }
    }

    private String generateJobName(Long newConfigurationId) {
        return String.format("%s-%d", TimeBasedConfigurationJob.class.getSimpleName(), newConfigurationId);
    }
}

