/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistic;
import at.mrdevelopment.esl.server.ServiceScheduler;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SimpleTrigger;

public class ESLJobListener
implements JobListener {
    static ESLLogger logger = ESLLogger.getLogger(ESLJobListener.class);
    private static final String LISTENER_NAME = "ESLJobListener";
    private final ServiceScheduler scheduler;

    public ESLJobListener(ServiceScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public String getName() {
        return LISTENER_NAME;
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        String jobName = context.getJobDetail().getKey().getName();
        JobStatistic jobStatistic = this.getStatistic(jobName, context);
        if (jobStatistic != null && (jobStatistic.isEnabled() || context.getTrigger() instanceof SimpleTrigger)) {
            logger.info("Starting job %s", new Object[]{jobStatistic.toString()});
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        String jobName = context.getJobDetail().getKey().getName();
        JobStatistic jobStatistic = this.getStatistic(jobName, context);
        if (jobStatistic != null && (jobStatistic.isEnabled() || context.getTrigger() instanceof SimpleTrigger)) {
            if (exception == null) {
                logger.info("Job execution successfully finished: %s", new Object[]{jobName});
            } else {
                logger.warn("Error during execution of job %s: %s", new Object[]{jobName, exception.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exception);
            }
        }
    }

    private JobStatistic getStatistic(String jobName, JobExecutionContext context) {
        try {
            JobStatistic jobStatistic = this.scheduler.getJobStatistic(jobName, context);
            return jobStatistic;
        }
        catch (InitializationException exc) {
            logger.warn("Could not load job statistics for job %s: %s", new Object[]{jobName, exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            return null;
        }
    }
}

