/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.battery.BatteryClassificationCache;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.BatteryReplacementRecordDataset;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelEventDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.job.IdentifiableInterruptableJob;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.server.PersistLabelInfoCache;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public abstract class ESLJob
implements IdentifiableInterruptableJob {
    static ESLLogger logger = ESLLogger.getLogger(ESLJob.class);
    public static final String KEY_JOB_IDENTIFIER = "jobIdentifier";
    public static final String KEY_UPDATE_STATUS_DATASET = "updateStatusDataset";
    public static final String KEY_LABEL_INFO_HISTORY_DATASET = "labelInfoHistoryDataset";
    public static final String KEY_LABEL_PAGE_CONTENT_DATASET = "labelPageContentDataset";
    public static final String KEY_LABEL_ACTIVE_PAGE_DATASET = "labelActivePageDataset";
    public static final String KEY_LEVEL1_IMPLEMENTATION_DATASET = "level1";
    public static final String KEY_BATTERY_REPLACEMENT_DATASET = "batteryReplacementRecordDataset";
    public static final String KEY_LABEL_EVENT_DATASET = "labelEventDataset";
    public static final String KEY_LABEL_DETAIL_DATASET = "labelDetailDataset";
    public static final String KEY_CLEANUP_STRATEGY = "cleanupStrategy";
    public static final String KEY_SESSION_FACTORY = "sessionFactory";
    public static final String KEY_PERSIST_LABEL_INFO_CACHE = "persistLabelInfoCache";
    public static final String KEY_LABEL_INFO_DATASET = "labelInfoDataset";
    public static final String KEY_BATTERY_CLASSIFICATION_CACHE = "batteryClassificationCache";
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_CONFIGURATION_DATASET = "configurationDataset";
    public static final String KEY_MANUAL_TRIGGER = "manualTrigger";
    public static final String KEY_PREVIOUS_EXECUTION = "previousExecution";
    public static final String KEY_EXECUTED = "executed";
    public static final String KEY_CONFIGURATION_KEY = "configurationKey";
    public static final String KEY_CONFIGURATION_VALUE = "configurationValue";
    private static final String KEY_PROGRESS = "progress";
    private static final String KEY_MAX_PROGRESS = "maxProgress";
    private Thread currentThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block10: {
            this.currentThread = Thread.currentThread();
            try {
                if (this.isEnabled(context)) {
                    logger.info("Running job: %s", new Object[]{this.getJobIdentifier(context)});
                    JobDataMap data = context.getJobDetail().getJobDataMap();
                    DateTime startTime = DateTime.now();
                    long startMillis = startTime.getMillis();
                    try {
                        this.executeInternal(context);
                        break block10;
                    }
                    finally {
                        if (!Thread.interrupted()) {
                            data.put(KEY_PREVIOUS_EXECUTION, (Object)startTime);
                            int count = 0;
                            if (data.containsKey((Object)this.getExecutionCountKey(context))) {
                                count = data.getInt(this.getExecutionCountKey(context));
                            }
                            data.put(this.getExecutionCountKey(context), ++count);
                            long duration = System.currentTimeMillis() - startMillis;
                            data.put(this.getExecutionTimeKey(context), duration);
                        }
                        data.put(KEY_MANUAL_TRIGGER, false);
                        this.jobExecutionFinished(context);
                    }
                }
                this.jobNotExecuted(context);
            }
            catch (DatasetException exc) {
                throw new JobExecutionException((Throwable)exc);
            }
            catch (Exception exc) {
                if (exc instanceof JobExecutionException) {
                    throw (JobExecutionException)exc;
                }
                throw new JobExecutionException((Throwable)exc);
            }
        }
    }

    private void jobExecutionFinished(JobExecutionContext context) {
        context.getJobDetail().getJobDataMap().put(KEY_EXECUTED, true);
    }

    protected void jobNotExecuted(JobExecutionContext context) {
        context.getJobDetail().getJobDataMap().put(KEY_EXECUTED, false);
    }

    protected void updateProgress(JobExecutionContext context, int progress, int maxProgress) {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        data.put(KEY_PROGRESS, progress);
        data.put(KEY_MAX_PROGRESS, maxProgress);
    }

    private boolean isEnabled(JobExecutionContext context) throws DatasetException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        if (context.getMergedJobDataMap().containsKey((Object)KEY_MANUAL_TRIGGER) && context.getMergedJobDataMap().getBoolean(KEY_MANUAL_TRIGGER)) {
            return true;
        }
        if (data.containsKey((Object)KEY_ENABLED)) {
            ConfigurationDataset configurationDataset = this.getConfigurationDataset(context);
            TransactionSupplier transactionSupplier = this.getTransactionSupplier(context);
            String enabledKey = data.getString(KEY_ENABLED);
            Transaction transaction = transactionSupplier.newTransaction();
            try {
                Configuration configuration = configurationDataset.getConfiguration(enabledKey, transaction);
                transaction.commit();
                if (configuration.getValue() == null) {
                    return false;
                }
                if (configuration.getType().equals((Object)BasicType.BOOLEAN)) {
                    return (Boolean)configuration.getParsedValue();
                }
                if (configuration.getType().equals((Object)BasicType.INTEGER)) {
                    return (Integer)configuration.getParsedValue() > 0;
                }
                return false;
            }
            catch (Exception exc) {
                transaction.rollback();
                throw new DatasetException((Throwable)exc);
            }
        }
        return true;
    }

    protected abstract void executeInternal(JobExecutionContext var1) throws JobExecutionException;

    public void interrupt() {
        if (this.currentThread != null) {
            this.currentThread.interrupt();
        }
    }

    private String getExecutionCountKey(JobExecutionContext context) {
        return String.format("%sExecutionCount", this.getJobIdentifier(context));
    }

    private String getExecutionTimeKey(JobExecutionContext context) {
        return String.format("%sExecutionTime", this.getJobIdentifier(context));
    }

    protected UpdateStatusDataset getUpdateStatusDataset(JobExecutionContext context) {
        return (UpdateStatusDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_UPDATE_STATUS_DATASET));
    }

    protected LabelInfoHistoryDataset getLabelInfoHistoryDataset(JobExecutionContext context) {
        return (LabelInfoHistoryDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_LABEL_INFO_HISTORY_DATASET));
    }

    protected LabelPageContentDataset getLabelPageContentDataset(JobExecutionContext context) {
        return (LabelPageContentDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_LABEL_PAGE_CONTENT_DATASET));
    }

    protected LabelActivePageDataset getLabelActivePageDataset(JobExecutionContext context) {
        return (LabelActivePageDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_LABEL_ACTIVE_PAGE_DATASET));
    }

    protected Level1Implementation getLevel1(JobExecutionContext context) {
        return (Level1Implementation)context.getJobDetail().getJobDataMap().get((Object)KEY_LEVEL1_IMPLEMENTATION_DATASET);
    }

    protected BatteryReplacementRecordDataset getBatteryReplacementDataset(JobExecutionContext context) {
        return (BatteryReplacementRecordDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_BATTERY_REPLACEMENT_DATASET));
    }

    protected LabelEventDataset getLabelEventDataset(JobExecutionContext context) {
        return (LabelEventDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_LABEL_EVENT_DATASET));
    }

    protected LabelDetailDataset getLabelDetailDataset(JobExecutionContext context) {
        return (LabelDetailDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_LABEL_DETAIL_DATASET));
    }

    protected TransactionSupplier getTransactionSupplier(JobExecutionContext context) {
        return this.getLevel1(context).getTransactionSupplier();
    }

    protected DatabaseMaintenanceStrategy getCleanupStrategy(JobExecutionContext context) {
        return (DatabaseMaintenanceStrategy)context.getJobDetail().getJobDataMap().get((Object)KEY_CLEANUP_STRATEGY);
    }

    protected SessionFactory getSessionFactory(JobExecutionContext context) {
        return (SessionFactory)context.getJobDetail().getJobDataMap().get((Object)KEY_SESSION_FACTORY);
    }

    protected PersistLabelInfoCache getLabelInfoCache(JobExecutionContext context) {
        return (PersistLabelInfoCache)context.getJobDetail().getJobDataMap().get((Object)KEY_PERSIST_LABEL_INFO_CACHE);
    }

    protected LabelInfoDataset getLabelInfoDataset(JobExecutionContext context) {
        return (LabelInfoDataset)context.getJobDetail().getJobDataMap().get((Object)KEY_LABEL_INFO_DATASET);
    }

    protected BatteryClassificationCache getBatteryClassificationCache(JobExecutionContext context) {
        return (BatteryClassificationCache)context.getJobDetail().getJobDataMap().get((Object)KEY_BATTERY_CLASSIFICATION_CACHE);
    }

    protected ConfigurationDataset getConfigurationDataset(JobExecutionContext context) {
        return (ConfigurationDataset)((Object)context.getJobDetail().getJobDataMap().get((Object)KEY_CONFIGURATION_DATASET));
    }
}

