/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatistics;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatisticsGenerator;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseTableSizeStatistic;
import at.mrdevelopment.esl.persistence.maintenance.DiskSpaceRelatedMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.ReadUncommittedTransactionSupplier;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DatabaseStatisticsJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(DatabaseStatisticsJob.class);
    public static final String KEY_DATABASE_STATISTICS_GENERATOR = "databaseStatisticsGenerator";
    public static final String KEY_DISK_SPACE_RELATED_STRATEGY = "diskSpaceRelatedMaintenanceStrategy";

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        DiskSpaceRelatedMaintenanceStrategy diskSpaceRelatedMaintenanceStrategy = this.getDiskSpaceRelatedMaintenanceStrategy(context);
        diskSpaceRelatedMaintenanceStrategy.executeShutdownOnExceedingThreshold(this.getLevel1(context));
        TransactionSupplier transactionSupplier = this.getTransactionSupplier(context);
        DatabaseSizeStatisticsGenerator databaseStatisticsGenerator = this.getDatabaseStatisticsGenerator(context);
        try {
            ORMTransaction transaction = ReadUncommittedTransactionSupplier.fromTransactionSupplier(transactionSupplier).newTransaction();
            try {
                DatabaseSizeStatistics statistics = databaseStatisticsGenerator.updateStatistics(transaction);
                logger.info(statistics.toString());
                if (logger.isDebugEnabled()) {
                    for (DatabaseTableSizeStatistic statistic : statistics.getStatistics()) {
                        logger.debug(statistic.toString());
                    }
                }
                transaction.commit();
            }
            catch (Exception exc) {
                transaction.rollback();
                throw new JobExecutionException((Throwable)exc);
            }
        }
        catch (DatasetException exc) {
            throw new JobExecutionException((Throwable)exc);
        }
    }

    private DatabaseSizeStatisticsGenerator getDatabaseStatisticsGenerator(JobExecutionContext context) {
        return (DatabaseSizeStatisticsGenerator)context.getJobDetail().getJobDataMap().get((Object)KEY_DATABASE_STATISTICS_GENERATOR);
    }

    private DiskSpaceRelatedMaintenanceStrategy getDiskSpaceRelatedMaintenanceStrategy(JobExecutionContext context) {
        return (DiskSpaceRelatedMaintenanceStrategy)context.getJobDetail().getJobDataMap().get((Object)KEY_DISK_SPACE_RELATED_STRATEGY);
    }
}

