/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.esl.persistence.transaction.DatabaseCleanupTransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DatabaseCleanupJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(DatabaseCleanupJob.class);

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            ORMTransaction transaction = DatabaseCleanupTransactionSupplier.fromTransactionSupplier(this.getTransactionSupplier(context)).newTransaction();
            try {
                DatabaseMaintenanceStrategy cleanupStrategy = this.getCleanupStrategy(context);
                logger.info("Cleaning up database using strategy: %s", new Object[]{cleanupStrategy.getClass().getSimpleName()});
                cleanupStrategy.cleanup(this.getLevel1(context), this.getUpdateStatusDataset(context), this.getLabelInfoHistoryDataset(context), this.getLabelPageContentDataset(context), this.getLabelActivePageDataset(context), this.getBatteryReplacementDataset(context), this.getLabelEventDataset(context), this.getLabelDetailDataset(context), transaction);
                transaction.commit();
            }
            catch (Exception exc) {
                transaction.rollback();
                throw new JobExecutionException((Throwable)exc);
            }
        }
        catch (DatasetException exc) {
            throw new JobExecutionException((Throwable)exc);
        }
    }
}

