/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractCronJobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.ESLJob;
import at.mrdevelopment.esl.persistence.record.Configuration;

public class CronBasedJobConfiguration
extends AbstractCronJobConfiguration {
    private final String configKeyEnabled;
    private final String configKeySchedule;
    private final Configuration enabledConfiguration;
    private final Configuration scheduleConfiguration;

    public CronBasedJobConfiguration(Class<? extends ESLJob> jobClass, String configKeyEnabled, String configKeySchedule, ConfigurationDataset configurationDataset, Transaction<?> transaction) throws DatasetException {
        super(jobClass);
        this.configKeyEnabled = configKeyEnabled;
        this.configKeySchedule = configKeySchedule;
        this.enabledConfiguration = configurationDataset.getConfiguration(configKeyEnabled, transaction);
        this.updateEnabledState(this.enabledConfiguration.getValue());
        this.scheduleConfiguration = configurationDataset.getConfiguration(configKeySchedule, transaction);
    }

    public String getConfigKeyEnabled() {
        return this.configKeyEnabled;
    }

    public String getConfigKeySchedule() {
        return this.configKeySchedule;
    }

    public Configuration getEnabledConfiguration() {
        return this.enabledConfiguration;
    }

    public Configuration getScheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    @Override
    public String getSchedule() {
        return this.scheduleConfiguration.getValue();
    }

    @Override
    public String getDefaultSchedule() {
        return this.scheduleConfiguration.getDefaultValue();
    }
}

