/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.battery.BatteryClassificationCache;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.ReadUncommittedTransactionSupplier;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BatteryClassificationJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(BatteryClassificationJob.class);
    private static final int BATCH_COUNT = 100;

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        TransactionSupplier transactionSupplier = this.getTransactionSupplier(context);
        BatteryClassificationCache batteryClassificationCache = this.getBatteryClassificationCache(context);
        LabelInfoDataset labelInfoDataset = this.getLabelInfoDataset(context);
        LabelDetailDataset labelDetailDataset = this.getLabelDetailDataset(context);
        try {
            ORMTransaction transaction = ReadUncommittedTransactionSupplier.fromTransactionSupplier(transactionSupplier).newTransaction();
            try {
                List<LabelInfo> labelInfos = labelInfoDataset.queryAll(transaction);
                logger.info("Calculating battery status for %d labels", new Object[]{labelInfos.size()});
                int count = 0;
                for (LabelInfo labelInfo : labelInfos) {
                    if (!labelInfo.isOnline()) continue;
                    batteryClassificationCache.updateCalculation(labelInfo, labelDetailDataset, transaction);
                    if (++count % 100 != 0) continue;
                    transaction.commit();
                    transaction = ReadUncommittedTransactionSupplier.fromTransactionSupplier(transactionSupplier).newTransaction();
                }
                transaction.commit();
            }
            catch (Exception exc) {
                transaction.rollback();
                throw new JobExecutionException((Throwable)exc);
            }
        }
        catch (DatasetException exc) {
            throw new JobExecutionException((Throwable)exc);
        }
    }
}

