/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.esl.persistence.maintenance.job.LabelDataCollectorConfiguration;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.ScheduledTaskCountQuery;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.ReadUncommittedTransactionSupplier;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.type.InternalTaskOrder;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractLabelDataCollectorJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(AbstractLabelDataCollectorJob.class);
    public static final String KEY_CONFIGURATION = "collectorConfiguration";
    private static final int RELOAD_TIMEOUT_SECONDS = 15;

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        ReadUncommittedTransactionSupplier transactionSupplier = ReadUncommittedTransactionSupplier.fromTransactionSupplier(this.getTransactionSupplier(context));
        try {
            ORMTransaction transaction = transactionSupplier.newTransaction();
            logger.info("Executing label data collector job: %s", new Object[]{this.getClass().getSimpleName()});
            LabelInfoDataset labelInfoDataset = this.getLabelInfoDataset(context);
            List<LabelInfo> labelInfos = labelInfoDataset.queryAll(transaction);
            Collection onlineLabelInfos = Collections2.filter(labelInfos, (Predicate)new Predicate<LabelInfo>(){

                public boolean apply(LabelInfo labelInfo) {
                    return labelInfo.isOnline();
                }
            });
            List<Object> tasks = Lists.newArrayList();
            try {
                tasks = this.createTasks(onlineLabelInfos, context, transaction);
                transaction.commit();
            }
            catch (Exception exc) {
                transaction.rollback();
                throw new JobExecutionException((Throwable)exc);
            }
            Level1Implementation level1 = this.getLevel1(context);
            List partitions = Lists.partition((List)tasks, (int)Config.getDataCollectorBatchSize());
            for (int index = 0; index < partitions.size(); ++index) {
                this.checkAndWait(level1, transactionSupplier);
                level1.addTasks((TaskOrder)new InternalTaskOrder(String.format("%s (%d/%d)", this.getTaskOrderName(), index + 1, partitions.size()), 0L, (List)partitions.get(index)));
            }
        }
        catch (Exception exc) {
            throw new JobExecutionException((Throwable)exc);
        }
    }

    private void checkAndWait(Level1Implementation level1, TransactionSupplier transactionSupplier) throws DatasetException, InterruptedException {
        int waitingTaskCount = -1;
        int scheduledTaskCount = -1;
        DatasetQuery waitingTaskQuery = level1.getQuery("updatestatus/waiting/all");
        DatasetQuery scheduledTaskQuery = level1.getQuery("scheduledtaskcount");
        while (waitingTaskCount + scheduledTaskCount < 0 || waitingTaskCount + scheduledTaskCount > Config.getDataCollectorWaitingTaskLimit()) {
            if (waitingTaskCount + scheduledTaskCount >= 0) {
                this.sleep(15, TimeUnit.SECONDS);
            }
            Transaction transaction = transactionSupplier.newTransaction();
            try {
                waitingTaskCount = waitingTaskQuery.getCount(QueryRestriction.newUnpagedQuery(), transaction);
                List records = scheduledTaskQuery.getResult(QueryRestriction.newUnpagedQuery(), transaction).getRecords();
                if (records.size() == 1) {
                    scheduledTaskCount = ((ScheduledTaskCountQuery.IntegerRecord)records.get(0)).getValue();
                }
                transaction.commit();
            }
            catch (DatasetException exc) {
                transaction.rollback();
                throw exc;
            }
        }
    }

    private void sleep(int reloadTimeout, TimeUnit unit) throws InterruptedException {
        unit.sleep(reloadTimeout);
    }

    protected abstract List<Task> createTasks(Collection<LabelInfo> var1, JobExecutionContext var2, Transaction<?> var3) throws Exception;

    protected abstract String getTaskOrderName();

    protected LabelDataCollectorConfiguration getConfiguration(JobExecutionContext context) {
        return (LabelDataCollectorConfiguration)context.getJobDetail().getJobDataMap().get((Object)KEY_CONFIGURATION);
    }
}

