/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.server.ESLDriver;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class ESLDatabaseConfiguration
extends Configuration {
    static ESLLogger logger = ESLLogger.getLogger(ESLDatabaseConfiguration.class);
    private static final String[] AFFECTED_TABLES = new String[]{"ESL_LABEL_INFO_HISTORY", "ESL_UPDATE_HISTORY", "ESL_TASK", "ESL_TRANSACTION", "ESL_LABEL_DETAIL", "ESL_UPDATE_IMAGE", "ESL_LABEL_PAGE_CONTENT"};
    private volatile boolean purgePending = false;

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        if (this.purgePending) {
            Object[] drop = super.generateDropSchemaScript(dialect);
            Collection filter = Collections2.filter((Collection)Lists.newArrayList((Object[])drop), (Predicate)new AffectedTablesFilter());
            return filter.toArray(new String[filter.size()]);
        }
        return super.generateDropSchemaScript(dialect);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        if (this.purgePending) {
            Object[] drop = super.generateSchemaCreationScript(dialect);
            Collection filter = Collections2.filter((Collection)Lists.newArrayList((Object[])drop), (Predicate)new AffectedTablesFilter());
            return filter.toArray(new String[filter.size()]);
        }
        return super.generateSchemaCreationScript(dialect);
    }

    public synchronized void purgeTables() {
        logger.info("Starting database table purging");
        this.purgePending = true;
        PrintStream outStream = System.out;
        PrintStream errorStream = System.err;
        System.setOut(new TracingPrintStream(outStream, false));
        System.setErr(new TracingPrintStream(outStream, true));
        SchemaExport schema = new SchemaExport((Configuration)this);
        schema.execute(true, true, false, false);
        System.setOut(outStream);
        System.setErr(errorStream);
        this.purgePending = false;
    }

    private void injectDriver(Configuration configuration) throws HibernateException {
        String property = configuration.getProperty("connection.driver_class");
        try {
            DriverManager.registerDriver(new ESLDriver((Driver)Thread.currentThread().getContextClassLoader().loadClass(property).newInstance()));
        }
        catch (Exception exc) {
            throw new HibernateException((Throwable)exc);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        Configuration configuration = super.configure(configFile);
        this.injectDriver(configuration);
        return configuration;
    }

    public Configuration configure() throws HibernateException {
        Configuration configuration = super.configure();
        this.injectDriver(configuration);
        return configuration;
    }

    public Configuration configure(String resource) throws HibernateException {
        Configuration configuration = super.configure(resource);
        this.injectDriver(configuration);
        return configuration;
    }

    public Configuration configure(URL url) throws HibernateException {
        Configuration configuration = super.configure(url);
        this.injectDriver(configuration);
        return configuration;
    }

    private class TracingPrintStream
    extends PrintStream {
        private final boolean error;

        public TracingPrintStream(PrintStream printStream, boolean error) {
            super(printStream);
            this.error = error;
        }

        @Override
        public void println(String line) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement caller = stack[2];
            if (this.error) {
                logger.error("%s: %s", new Object[]{caller.getClassName(), line});
            } else {
                logger.debug("%s: %s", new Object[]{caller.getClassName(), line});
            }
        }
    }

    private class AffectedTablesFilter
    implements Predicate<String> {
        private AffectedTablesFilter() {
        }

        public boolean apply(String input) {
            for (String table : AFFECTED_TABLES) {
                if (!input.contains(table)) continue;
                return true;
            }
            return false;
        }
    }
}

