/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.server.FileSystemInformationListener;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.FileSystem;
import at.mrdevelopment.toolkit.os.FileSystemInfo;
import java.io.File;

public class DiskSpaceRelatedMaintenanceStrategy
implements FileSystemInformationListener {
    static ESLLogger logger = ESLLogger.getLogger(DiskSpaceRelatedMaintenanceStrategy.class);
    private static final int SHUTDOWN_RATIO = 90;
    private final File dataPartition;
    private FileSystemInfo fileSystemInfo;
    private boolean actionInProgress;

    public DiskSpaceRelatedMaintenanceStrategy(File dataPartition) {
        this.dataPartition = dataPartition;
    }

    public void executeShutdownOnExceedingThreshold(Level1Implementation level1) {
        FileSystem fileSystem;
        if (!this.actionInProgress && this.fileSystemInfo != null && (fileSystem = this.fileSystemInfo.getByFile(this.dataPartition)) != null && DiskSpaceRelatedMaintenanceStrategy.isDiskSpaceUsageOverShutdownThreshold(fileSystem)) {
            level1.shutdownService();
            this.actionInProgress = true;
        }
    }

    private static double getRatio(long first, long second) {
        return (double)first / (double)second * 100.0;
    }

    private static boolean isDiskSpaceUsageOverShutdownThreshold(FileSystem dataPartitionFileSystem) {
        long partitionTotalSize = dataPartitionFileSystem.getTotalSpaceInBytes();
        long partitionUsedBytes = dataPartitionFileSystem.getUsedSpaceInBytes();
        double usedPercent = DiskSpaceRelatedMaintenanceStrategy.getRatio(partitionUsedBytes, partitionTotalSize);
        if (usedPercent > 90.0) {
            logger.warn("Used disk space (%.2f %%) exeeds (%d %%) limit for file system %s ", new Object[]{usedPercent, 90, dataPartitionFileSystem.getFile().toString()});
            logger.error("Shutting down service due to low disk space on %s", new Object[]{dataPartitionFileSystem.getFile().toString()});
            return true;
        }
        return false;
    }

    public static boolean isPartitionOutOfSpace(File partition) {
        FileSystem fileSystem = new FileSystem(partition, null);
        return DiskSpaceRelatedMaintenanceStrategy.isDiskSpaceUsageOverShutdownThreshold(fileSystem);
    }

    @Override
    public void notifyFileSystemInformationUpdated(FileSystemInfo fileSystemInfo) {
        this.fileSystemInfo = fileSystemInfo;
    }
}

