/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatistics;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatisticsChangedListener;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseTableSizeStatistic;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Objects;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DatabaseSizeStatisticsGenerator {
    static ESLLogger logger = ESLLogger.getLogger(DatabaseSizeStatisticsGenerator.class);
    private static final String DIAGTABLE = "new org.apache.derby.diag.SpaceTable";
    private static final String DERBY_NAME = "Apache Derby Embedded JDBC Driver";
    private static final String SPACE_INFO_QUERY = "SELECT spaceinfo.* FROM SYS.SYSSCHEMAS s, SYS.SYSTABLES t, new org.apache.derby.diag.SpaceTable(SCHEMANAME,TABLENAME) spaceinfo WHERE s.SCHEMAID = t.SCHEMAID";
    private static final String COLUMN_PAGESIZE = "PAGESIZE";
    private static final String COLUMN_NUMFREEPAGES = "NUMFREEPAGES";
    private static final String COLUMN_ESTIMSPACESAVING = "ESTIMSPACESAVING";
    private static final String COLUMN_NUMALLOCATEDPAGES = "NUMALLOCATEDPAGES";
    private static final String COLUMN_CONGLOMERATENAME = "CONGLOMERATENAME";
    private DatabaseSizeStatistics statistics;
    private final List<DatabaseSizeStatisticsChangedListener> listeners = new CopyOnWriteArrayList<DatabaseSizeStatisticsChangedListener>();

    public DatabaseSizeStatistics updateStatistics(Transaction<?> transaction) throws DatasetException {
        this.statistics = this.reloadStatistics(transaction);
        this.notifyDatabaseSizeStatisticsChanged();
        return this.statistics;
    }

    private DatabaseSizeStatistics reloadStatistics(Transaction<?> transaction) throws DatasetException {
        ArrayList<DatabaseTableSizeStatistic> statistics = new ArrayList<DatabaseTableSizeStatistic>();
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        try {
            if (this.isDerbyDatabase(ormTransaction.getSession())) {
                Query query = ormTransaction.createSQLQuery(String.format(SPACE_INFO_QUERY, new Object[0]));
                query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                List sizes = query.list();
                for (Map map : sizes) {
                    long pageSize = Long.valueOf(map.get(COLUMN_PAGESIZE).toString());
                    long freePages = Long.valueOf(map.get(COLUMN_NUMFREEPAGES).toString());
                    long allocatedPages = Long.valueOf(map.get(COLUMN_NUMALLOCATEDPAGES).toString());
                    long spaceSaving = Long.valueOf(map.get(COLUMN_ESTIMSPACESAVING).toString());
                    long totalSize = pageSize * allocatedPages + pageSize * freePages;
                    long usedSize = totalSize - pageSize * freePages;
                    statistics.add(new DatabaseTableSizeStatistic(map.get(COLUMN_CONGLOMERATENAME).toString(), totalSize, usedSize, spaceSaving));
                }
                return new DatabaseSizeStatistics(statistics);
            }
        }
        catch (HibernateException exc) {
            throw new DatasetException((Throwable)exc);
        }
        return DatabaseSizeStatistics.EMPTY;
    }

    private boolean isDerbyDatabase(Session session) {
        try {
            DatabaseMetaData metaData;
            Connection connection;
            if (session != null && (connection = session.connection()) != null && (metaData = connection.getMetaData()) != null) {
                return Objects.equal((Object)metaData.getDriverName(), (Object)DERBY_NAME);
            }
        }
        catch (Exception exc) {
            logger.warn("Could not determine database type: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        return false;
    }

    public void addDatabaseSizeStatisticsChangedListener(DatabaseSizeStatisticsChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeDatabaseSizeStatisticsChangedListener(DatabaseSizeStatisticsChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyDatabaseSizeStatisticsChanged() {
        for (DatabaseSizeStatisticsChangedListener listener : this.listeners) {
            listener.databaseSizeStatisticsChanged(this.statistics);
        }
    }
}

