/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.persistence.maintenance.DatabaseTableSizeStatistic;
import at.mrdevelopment.toolkit.file.FileUtils;
import java.util.Collection;
import java.util.Collections;

public class DatabaseSizeStatistics {
    public static final DatabaseSizeStatistics EMPTY = new DatabaseSizeStatistics(Collections.<DatabaseTableSizeStatistic>emptyList(), -1L, -1L, -1L);
    private final Collection<DatabaseTableSizeStatistic> statistics;
    private final long totalSizeInBytes;
    private final long freeableSizeInBytes;
    private final long usedSizeInBytes;

    public DatabaseSizeStatistics(Collection<DatabaseTableSizeStatistic> statistics) {
        this.statistics = statistics;
        long size = 0L;
        long freeable = 0L;
        long used = 0L;
        for (DatabaseTableSizeStatistic statistic : statistics) {
            size += statistic.getSizeInBytes();
            freeable += statistic.getFreeableSizeInBytes();
            used += statistic.getUsedSizeInBytes();
        }
        this.totalSizeInBytes = size;
        this.freeableSizeInBytes = freeable;
        this.usedSizeInBytes = used;
    }

    private DatabaseSizeStatistics(Collection<DatabaseTableSizeStatistic> statistics, long totalSizeInBytes, long freeableSizeInBytes, long usedSizeInBytes) {
        this.statistics = statistics;
        this.totalSizeInBytes = totalSizeInBytes;
        this.freeableSizeInBytes = freeableSizeInBytes;
        this.usedSizeInBytes = usedSizeInBytes;
    }

    public Collection<DatabaseTableSizeStatistic> getStatistics() {
        return Collections.unmodifiableCollection(this.statistics);
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getFreeableSizeInBytes() {
        return this.freeableSizeInBytes;
    }

    public long getUsedSizeInBytes() {
        return this.usedSizeInBytes;
    }

    public String toString() {
        return String.format("Database statistic: total=%s, used=%s, freeable=%s", FileUtils.toReadableSize((long)this.totalSizeInBytes), FileUtils.toReadableSize((long)this.usedSizeInBytes), FileUtils.toReadableSize((long)this.freeableSizeInBytes));
    }
}

