/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.configuration.ConfigurationStorage;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.CriteriaSpecification;

public abstract class DatabaseMigration {
    static ESLLogger logger = ESLLogger.getLogger(DatabaseMigration.class);
    private static final int BATCH_SIZE = 10000;
    private static final Set<String> ENTITIES_TO_BE_IGNORED = Sets.newHashSet((Object[])new String[]{UpdateStatus.class.getName(), TaskRecord.class.getName(), LabelDetail.class.getName(), UpdateImage.class.getName(), TransactionRecord.class.getName(), LabelPageContent.class.getName()});
    private final SessionFactory destinationSessionFactory;
    private final SessionFactory sourceSessionFactory;

    public DatabaseMigration(SessionFactory destinationSessionFactory, SessionFactory sourceSessionFactory) throws InitializationException {
        this.destinationSessionFactory = destinationSessionFactory;
        this.sourceSessionFactory = sourceSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(ConfigurationStorage configurationStorage) throws HibernateException, SQLException {
        logger.info("Running database migration");
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger);
        timeLogger.start();
        Map entityInfos = this.destinationSessionFactory.getAllClassMetadata();
        try {
            this.disableConstraints(this.destinationSessionFactory);
            for (Map.Entry entityInfo : entityInfos.entrySet()) {
                this.migrateEntity((String)entityInfo.getKey());
            }
            this.enableConstraints(this.destinationSessionFactory);
        }
        finally {
            this.sourceSessionFactory.close();
        }
        this.cleanupArchiveHeader(configurationStorage);
        timeLogger.logTimeInfo("Finished database migration");
    }

    private void cleanupArchiveHeader(ConfigurationStorage configurationStorage) {
    }

    private void migrateEntity(String entityName) {
        block7: {
            if (!ENTITIES_TO_BE_IGNORED.contains(entityName)) {
                logger.debug("Migrating %s entities", new Object[]{entityName});
                Session sourceSession = this.sourceSessionFactory.openSession();
                Session destinationSession = this.destinationSessionFactory.openSession();
                System.out.println(entityName);
                try {
                    destinationSession.beginTransaction();
                    sourceSession.beginTransaction();
                    Criteria criteria = sourceSession.createCriteria(entityName);
                    criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                    List list = criteria.list();
                    int rowCount = 0;
                    for (Object record : list) {
                        ++rowCount;
                        try {
                            sourceSession.evict(record);
                            destinationSession.save(record);
                        }
                        catch (ClassCastException exc) {
                            Session session = this.destinationSessionFactory.openSession();
                            session.beginTransaction();
                            session.save(record);
                            session.getTransaction().commit();
                        }
                        if (rowCount % 10000 != 0) continue;
                        destinationSession.getTransaction().commit();
                        destinationSession.close();
                        destinationSession = this.destinationSessionFactory.openSession();
                        destinationSession.beginTransaction();
                    }
                    sourceSession.getTransaction().rollback();
                    sourceSession.close();
                    destinationSession.getTransaction().commit();
                }
                catch (Exception exc) {
                    logger.warn("Could not migrate %s: %s", new Object[]{entityName, exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                    if (sourceSession.getTransaction().isActive()) {
                        sourceSession.getTransaction().rollback();
                    }
                    if (!destinationSession.getTransaction().isActive()) break block7;
                    destinationSession.getTransaction().rollback();
                }
            }
        }
    }

    protected abstract void disableConstraints(SessionFactory var1) throws HibernateException, SQLException;

    protected abstract void enableConstraints(SessionFactory var1) throws HibernateException, SQLException;
}

