/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset.util;

import at.mrdevelopment.esl.core.ServiceAddress;

public class AccessPointUpdate {
    private int accessPointId;
    private ServiceAddress serviceAddress;
    private boolean isPermanentlyOffline;
    private boolean serviceToBeInitialized;
    private boolean autoConfigEnabled;
    private boolean thinModeEnabled;

    private AccessPointUpdate(Builder builder) {
        this.accessPointId = builder.accessPointId;
        this.serviceAddress = builder.serviceAddress;
        this.isPermanentlyOffline = builder.isPermanentlyOffline;
        this.serviceToBeInitialized = builder.serviceToBeInitialized;
        this.autoConfigEnabled = builder.autoConfigEnabled;
        this.thinModeEnabled = builder.thinModeEnabled;
        this.check();
    }

    private void check() {
        if (this.accessPointId < 0) {
            throw new IllegalArgumentException("AP-ID was not set via AccessPointUpdate.Builder!!!");
        }
        if (this.serviceAddress == null) {
            throw new IllegalArgumentException("Service address was not set via AccessPointUpdate.Builder!!!");
        }
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    public boolean isPermanentlyOffline() {
        return this.isPermanentlyOffline;
    }

    public boolean isServiceToBeInitialized() {
        return this.serviceToBeInitialized;
    }

    public boolean isAutoConfigEnabled() {
        return this.autoConfigEnabled;
    }

    public boolean isThinModeEnabled() {
        return this.thinModeEnabled;
    }

    public static class Builder {
        private int accessPointId = -1;
        private ServiceAddress serviceAddress = null;
        private boolean isPermanentlyOffline = false;
        private boolean serviceToBeInitialized = false;
        private boolean autoConfigEnabled = false;
        private boolean thinModeEnabled = false;

        public Builder accessPointId(int accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public Builder serviceAddress(ServiceAddress serviceAddress) {
            this.serviceAddress = serviceAddress;
            return this;
        }

        public Builder isPermanentlyOffline(boolean isPermanentlyOffline) {
            this.isPermanentlyOffline = isPermanentlyOffline;
            return this;
        }

        public Builder serviceToBeInitialized(boolean serviceToBeInitialized) {
            this.serviceToBeInitialized = serviceToBeInitialized;
            return this;
        }

        public Builder autoConfig(boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        public Builder thinMode(boolean thinModeEnabled) {
            this.thinModeEnabled = thinModeEnabled;
            return this;
        }

        public AccessPointUpdate build() {
            return new AccessPointUpdate(this);
        }
    }
}

