/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.Template;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class TemplateDataset
extends AbstractDataset<Template> {
    static ESLLogger logger = ESLLogger.getLogger(TemplateDataset.class);
    public static final String TEMPLATE_EXTENSION = "xsl";
    private List<Template> templates = new ArrayList<Template>();

    public TemplateDataset(Map<Role, DatasetPermissions> datasetPermissions) throws DatasetException, InitializationException {
        super(Template.class, datasetPermissions);
        this.reload((Transaction<?>)NoTransaction.get());
    }

    public Template queryById(long id, Transaction<?> transaction) throws DatasetException {
        throw new DatasetException("Query by ID not implemented", new Object[0]);
    }

    public synchronized List<Template> queryAll(Transaction<?> transaction) throws DatasetException {
        return Collections.unmodifiableList(new ArrayList<Template>(this.templates));
    }

    public synchronized int getRecordCount(Transaction<?> transaction) {
        return this.templates.size();
    }

    public void store(Collection<Template> records, UserId user, Transaction<?> transaction) {
    }

    public void delete(Collection<Template> records, UserId user, Transaction<?> transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abortable reload(Transaction<?> transaction) throws DatasetException {
        logger.debug("Reloading templates");
        File directory = new File(Config.getTemplatePath());
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FilenameUtils.getExtension((String)file.getAbsolutePath()).equals(TemplateDataset.TEMPLATE_EXTENSION);
            }
        };
        long templateId = 0L;
        ArrayList<Template> templates = new ArrayList<Template>();
        if (directory.exists() && directory.isDirectory()) {
            for (File templateFile : directory.listFiles(fileFilter)) {
                Template template = new Template(templateId++, templateFile.getName());
                templates.add(template);
            }
        } else {
            logger.warn("Template directory '%s' not found", new Object[]{directory.getAbsolutePath()});
        }
        TemplateDataset templateDataset = this;
        synchronized (templateDataset) {
            this.templates.clear();
            this.templates.addAll(templates);
        }
        this.notifyRecordsModified(templates, transaction);
        return Abortable.DO_NOTHING;
    }

    public void close() {
    }
}

