/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LinkQuality;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.labelstatistics.AccessPointDistributionLabelInfo;
import at.mrdevelopment.esl.labelstatistics.BatteryStatusLabelInfo;
import at.mrdevelopment.esl.labelstatistics.ConnectionStatusLabelInfo;
import at.mrdevelopment.esl.labelstatistics.EncryptionStatusLabelInfo;
import at.mrdevelopment.esl.labelstatistics.HardwareErrorsLabelInfo;
import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.LqiLabelInfo;
import at.mrdevelopment.esl.labelstatistics.RssiLabelInfo;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.esl.labelstatistics.SyncQualityLabelInfo;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LabelStatisticsDataset
extends AbstractDataset<LabelStatistics> {
    private final LabelInfoDataset labelInfoDataset;
    private final List<LabelStatistics> labelStatisticsList = new ArrayList<LabelStatistics>();

    public LabelStatisticsDataset(Map<Role, DatasetPermissions> datasetPermissions, LabelInfoDataset labelInfoDataset) throws InitializationException {
        super(LabelStatistics.class, datasetPermissions);
        this.labelInfoDataset = labelInfoDataset;
    }

    public LabelStatistics queryById(long id, Transaction<?> transaction) throws DatasetException {
        return null;
    }

    public List<LabelStatistics> queryAll(Transaction<?> transaction) throws DatasetException {
        return this.getLabelStatisticsList();
    }

    public int getRecordCount(Transaction<?> transaction) throws DatasetException {
        return this.getLabelStatisticsList().size();
    }

    public void store(Collection<LabelStatistics> records, UserId user, Transaction<?> transaction) throws DatasetException {
    }

    public void delete(Collection<LabelStatistics> records, UserId user, Transaction<?> transaction) throws DatasetException {
    }

    public Abortable reload(Transaction<?> transaction) throws DatasetException {
        this.labelStatisticsList.clear();
        DatasetQuery defaultQuery = this.labelInfoDataset.getDefaultQuery();
        List labelInfos = defaultQuery.getResult(QueryRestriction.newUnpagedQuery(), transaction).getRecords();
        this.addLabelInfoCategory(labelInfos);
        this.processLabelInfos(labelInfos);
        return Abortable.DO_NOTHING;
    }

    public void close() {
    }

    public boolean hasDefaultQuery() {
        return false;
    }

    private List<LabelStatistics> getLabelStatisticsList() throws DatasetException {
        this.reload((Transaction<?>)NoTransaction.get());
        return this.labelStatisticsList;
    }

    private void addLabelInfoCategory(Collection<LabelInfo> labelInfos) {
        int totalLabels = labelInfos.size();
        this.labelStatisticsList.add((LabelStatistics)new ConnectionStatusLabelInfo(StatisticCategory.CONNECTION_STATUS, ConnectionStatus.ONLINE, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new ConnectionStatusLabelInfo(StatisticCategory.CONNECTION_STATUS, ConnectionStatus.DISCOVERED, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new ConnectionStatusLabelInfo(StatisticCategory.CONNECTION_STATUS, ConnectionStatus.UNKNOWN, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new ConnectionStatusLabelInfo(StatisticCategory.CONNECTION_STATUS, ConnectionStatus.OFFLINE, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new BatteryStatusLabelInfo(StatisticCategory.BATTERY_STATUS, PowerStatus.GOOD, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new BatteryStatusLabelInfo(StatisticCategory.BATTERY_STATUS, PowerStatus.LOW, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new BatteryStatusLabelInfo(StatisticCategory.BATTERY_STATUS, PowerStatus.BAD, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new BatteryStatusLabelInfo(StatisticCategory.BATTERY_STATUS, PowerStatus.UNKNOWN, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new SyncQualityLabelInfo(StatisticCategory.SYNC_QUALITY, LinkQuality.PERFECT, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new SyncQualityLabelInfo(StatisticCategory.SYNC_QUALITY, LinkQuality.GOOD, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new SyncQualityLabelInfo(StatisticCategory.SYNC_QUALITY, LinkQuality.AVERAGE, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new SyncQualityLabelInfo(StatisticCategory.SYNC_QUALITY, LinkQuality.BAD, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new SyncQualityLabelInfo(StatisticCategory.SYNC_QUALITY, null, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(-70), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(-75), (Comparable)Integer.valueOf(-71)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(-80), (Comparable)Integer.valueOf(-76)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(-85), (Comparable)Integer.valueOf(-81)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(-90), (Comparable)Integer.valueOf(-86)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(-92), (Comparable)Integer.valueOf(-91)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, new Range((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(-93)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new RssiLabelInfo(StatisticCategory.RSSI, null, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new LqiLabelInfo(StatisticCategory.LQI, new Range((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(63)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new LqiLabelInfo(StatisticCategory.LQI, new Range((Comparable)Integer.valueOf(64), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new LqiLabelInfo(StatisticCategory.LQI, null, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new HardwareErrorsLabelInfo(StatisticCategory.HARDWARE_ERRORS, HardwareErrorsLabelInfo.HardwareErrors.HAS_NO_HARDWARE_ERRORS, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new HardwareErrorsLabelInfo(StatisticCategory.HARDWARE_ERRORS, HardwareErrorsLabelInfo.HardwareErrors.HAS_HARDWARE_ERRORS, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new HardwareErrorsLabelInfo(StatisticCategory.HARDWARE_ERRORS, HardwareErrorsLabelInfo.HardwareErrors.UNKNOWN, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new EncryptionStatusLabelInfo(StatisticCategory.ENCRYPTION_STATUS, SecurityStatus.AES128, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new EncryptionStatusLabelInfo(StatisticCategory.ENCRYPTION_STATUS, SecurityStatus.KEY_UNSET, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new EncryptionStatusLabelInfo(StatisticCategory.ENCRYPTION_STATUS, SecurityStatus.NO_PIN, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new EncryptionStatusLabelInfo(StatisticCategory.ENCRYPTION_STATUS, SecurityStatus.UNSUPPORTED, totalLabels));
        this.labelStatisticsList.add((LabelStatistics)new EncryptionStatusLabelInfo(StatisticCategory.ENCRYPTION_STATUS, SecurityStatus.UNKNOWN, totalLabels));
        HashSet<Integer> accessPointIds = new HashSet<Integer>();
        for (LabelInfo labelInfo : labelInfos) {
            accessPointIds.add(labelInfo.getAccessPointId());
        }
        for (Integer accessPointId : accessPointIds) {
            this.labelStatisticsList.add((LabelStatistics)new AccessPointDistributionLabelInfo(StatisticCategory.LABEL_DISTRIBUTION, accessPointId, totalLabels));
        }
    }

    private void processLabelInfos(Collection<LabelInfo> labelInfos) {
        for (LabelInfo labelInfo : labelInfos) {
            for (LabelStatistics info : this.labelStatisticsList) {
                info.process(labelInfo);
            }
        }
    }
}

